/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.art.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.neoforged.art.api.ClassProvider;

class SortedClassProvider
implements ClassProvider {
    List<ClassProvider> classProviders;
    private final Consumer<String> debug;
    private final Map<String, Optional<? extends ClassProvider.IClassInfo>> classCache = new ConcurrentHashMap<String, Optional<? extends ClassProvider.IClassInfo>>();

    SortedClassProvider(List<ClassProvider> classProviders, Consumer<String> debug) {
        this.classProviders = classProviders;
        this.debug = debug;
    }

    @Override
    public Optional<? extends ClassProvider.IClassInfo> getClass(String cls) {
        return this.classCache.computeIfAbsent(cls, this::computeClassInfo);
    }

    private Optional<? extends ClassProvider.IClassInfo> computeClassInfo(String name) {
        for (ClassProvider classProvider : this.classProviders) {
            Optional<? extends ClassProvider.IClassInfo> classInfo = classProvider.getClass(name);
            if (!classInfo.isPresent()) continue;
            return classInfo;
        }
        this.debug.accept("Can't Find Class: " + name);
        return Optional.empty();
    }

    void clearCache() {
        this.classCache.clear();
    }

    @Override
    public void close() throws IOException {
        for (ClassProvider classProvider : this.classProviders) {
            classProvider.close();
        }
    }
}

