/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.art.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.jar.Manifest;
import net.neoforged.art.api.Transformer;

public abstract class EntryImpl
implements Transformer.Entry {
    private final String name;
    private final long time;
    private byte[] data;

    protected EntryImpl(String name, long time, byte[] data) {
        this.name = name;
        this.time = time;
        this.data = Objects.requireNonNull(data, "data");
    }

    protected EntryImpl(String name, long time) {
        this.name = name;
        this.time = time;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    protected final void setData(byte[] data) {
        if (this.data != null) {
            throw new IllegalStateException("Can only set data if it wasn't set already.");
        }
        this.data = data;
    }

    public static class JavadoctorEntry
    extends EntryImpl
    implements Transformer.JavadoctorEntry {
        public JavadoctorEntry(long time, byte[] data) {
            super("javadoctor.json", time, data);
        }

        @Override
        public Transformer.JavadoctorEntry process(Transformer transformer) {
            return transformer.process(this);
        }
    }

    public static class ManifestEntry
    extends EntryImpl
    implements Transformer.ManifestEntry {
        private Manifest manifest;

        public ManifestEntry(long time, byte[] data) {
            super("META-INF/MANIFEST.MF", time, data);
        }

        public ManifestEntry(long time, Manifest manifest) {
            super("META-INF/MANIFEST.MF", time);
            this.manifest = Objects.requireNonNull(manifest, "manifest");
        }

        @Override
        public Manifest getManifest() {
            if (this.manifest == null) {
                try {
                    this.manifest = new Manifest(new ByteArrayInputStream(this.getData()));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Couldn't parse manifest", e);
                }
            }
            return this.manifest;
        }

        @Override
        public byte[] getData() {
            if (super.getData() == null) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    this.manifest.write(bos);
                    this.setData(bos.toByteArray());
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Couldn't serialize manifest", e);
                }
            }
            return super.getData();
        }

        @Override
        public Transformer.ManifestEntry process(Transformer transformer) {
            return transformer.process(this);
        }
    }

    public static class ResourceEntry
    extends EntryImpl
    implements Transformer.ResourceEntry {
        public ResourceEntry(String name, long time, byte[] data) {
            super(name, time, data);
        }

        @Override
        public Transformer.ResourceEntry process(Transformer transformer) {
            return transformer.process(this);
        }
    }

    public static class ClassEntry
    extends EntryImpl
    implements Transformer.ClassEntry {
        private static final String VERSION_PREFIX = "META-INF/versions/";
        private final int release;
        private final String className;

        public ClassEntry(String name, long time, byte[] data) {
            super(name, time, data);
            if (name.startsWith(VERSION_PREFIX)) {
                int start = VERSION_PREFIX.length();
                int idx = name.indexOf(47, start);
                if (idx == -1) {
                    throw new IllegalArgumentException("Invalid versioned class entry: " + name);
                }
                this.release = Integer.parseInt(name.substring(start, idx));
                name = name.substring(idx + 1);
            } else {
                this.release = -1;
            }
            this.className = name.substring(0, name.length() - 6);
        }

        @Override
        public Transformer.ClassEntry process(Transformer transformer) {
            return transformer.process(this);
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public boolean isMultiRelease() {
            return this.release != -1;
        }

        @Override
        public int getVersion() {
            return this.release;
        }
    }
}

