/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fart.internal.EnhancedRemapper;
import net.neoforged.javadoctor.spec.ClassJavadoc;
import net.neoforged.javadoctor.spec.DocReferences;
import net.neoforged.javadoctor.spec.JavadocEntry;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class JavadoctorRemapper {
    public static final Pattern LINKS = Pattern.compile("@(?<tag>link|linkplain|see|value)(?<space>\\s+)(?<owner>[\\w$.]*)(?:#(?<member>[\\w%]+)?(?<descFull>\\((?<desc>[\\w$., \\[\\]]+)?\\))?)?");
    public static final Pattern LINKS_IN = Pattern.compile("^(?<owner>[\\w$.]*)(?:#(?<member>[\\w%]+)?(?<descFull>\\((?<desc>[\\w$., \\[\\]]+)?\\))?)?");
    private final EnhancedRemapper remapper;
    private final DocReferences references;

    public JavadoctorRemapper(EnhancedRemapper remapper, DocReferences references) {
        this.remapper = remapper;
        this.references = references;
    }

    public ClassJavadoc remap(String containedClass, String containedInternalName, ClassJavadoc doc) {
        HashMap inners = new HashMap(doc.innerClasses().size(), 1.0f);
        doc.innerClasses().forEach((name, cdoc) -> {
            String innerName = containedClass + "." + name;
            String innerInternal = containedInternalName + "$" + name;
            String remappedInner = this.remapper.map(innerInternal);
            inners.put(remappedInner.substring(remappedInner.lastIndexOf(36) + 1), this.remap(innerName, innerInternal, (ClassJavadoc)cdoc));
        });
        return new ClassJavadoc(doc.clazz() == null ? null : this.remap(containedClass, doc.clazz()), this.mapEntries(containedClass, doc.methods(), method -> {
            int start = method.indexOf(40);
            String name = method.substring(0, start);
            String desc = method.substring(start);
            return this.remapper.mapMethodName(containedInternalName, name, desc) + this.remapper.mapMethodDesc(desc);
        }), this.mapEntries(containedClass, doc.fields(), field -> {
            String[] nameAndDesc = field.split(":");
            return this.remapper.mapFieldName(containedInternalName, nameAndDesc[0], nameAndDesc[1]) + ":" + this.remapper.mapDesc(nameAndDesc[1]);
        }), inners);
    }

    @Nullable
    private Map<String, JavadocEntry> mapEntries(String containedClass, @Nullable Map<String, JavadocEntry> entries, UnaryOperator<String> remapper) {
        if (entries == null) {
            return null;
        }
        HashMap<String, JavadocEntry> newEntries = new HashMap<String, JavadocEntry>(entries.size(), 1.0f);
        entries.forEach((key, entry) -> newEntries.put((String)remapper.apply((String)key), this.remap(containedClass, (JavadocEntry)entry)));
        return newEntries;
    }

    private JavadocEntry remap(String containedClass, JavadocEntry entry) {
        return new JavadocEntry(entry.doc() == null ? null : this.replaceLinks(containedClass, LINKS.matcher(entry.doc()), matcher -> "@" + matcher.group(1) + matcher.group(2)), entry.tags() == null ? null : this.mapTags(containedClass, entry.tags()), entry.parameters() == null ? null : this.mapParams(containedClass, entry.parameters()), entry.typeParameters() == null ? null : this.mapParams(containedClass, entry.typeParameters()));
    }

    private Map<String, List<String>> mapTags(String containedClass, Map<String, List<String>> in) {
        HashMap<String, List<String>> tags = new HashMap<String, List<String>>(in.size(), 1.0f);
        in.forEach((tagName, values) -> {
            ArrayList newValues = new ArrayList(values);
            if (tagName.equals("see")) {
                newValues.replaceAll(seeTag -> this.replaceLinks(containedClass, LINKS_IN.matcher((CharSequence)seeTag), matcher -> ""));
            } else {
                newValues.replaceAll(tag -> this.replaceLinks(containedClass, LINKS.matcher((CharSequence)tag), matcher -> "@" + matcher.group(1) + matcher.group(2)));
            }
            tags.put((String)tagName, newValues);
        });
        return tags;
    }

    private String[] mapParams(String containedClass, String[] params) {
        String[] newParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            if (param != null) {
                param = this.replaceLinks(containedClass, LINKS.matcher(param), matcher -> "@" + matcher.group(1) + matcher.group(2));
            }
            newParams[i] = param;
        }
        return newParams;
    }

    private String replaceLinks(String containedClass, Matcher matcher, Function<Matcher, String> prefix) {
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String matchedOwner = matcher.group("owner");
            String owner = this.references.getInternalName(matchedOwner == null || matchedOwner.isEmpty() ? containedClass : matchedOwner);
            String mappedOwner = this.remapper.map(owner);
            StringBuilder replacement = new StringBuilder().append(prefix.apply(matcher)).append(mappedOwner.replace('/', '.').replace('$', '.'));
            String member = matcher.group("member");
            if (member != null) {
                replacement.append('#');
                String descFull = matcher.group("descFull");
                boolean hasDesc = descFull != null && !descFull.isEmpty();
                String desc = matcher.group("desc");
                if (hasDesc) {
                    String finalDesc = desc == null ? "" : desc;
                    String[] descSplit = finalDesc.isEmpty() ? new String[]{} : finalDesc.split(",");
                    replacement.append(this.remapper.mapJavadocMember(owner, member, descSplit.length).orElseGet(() -> member + "(" + finalDesc + ")"));
                } else {
                    replacement.append(this.remapper.mapFieldName(owner, member, null));
                }
            } else if (mappedOwner.equals(owner)) {
                matcher.appendReplacement(sb, matcher.group(0));
                continue;
            }
            matcher.appendReplacement(sb, replacement.toString());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static String getJavadocDesc(Type type) {
        return "(" + Stream.of(type.getArgumentTypes()).map(JavadoctorRemapper::getJavadocType).collect(Collectors.joining(", ")) + ")";
    }

    static String getJavadocType(Type type) {
        switch (type.getSort()) {
            case 1: {
                return "boolean";
            }
            case 5: {
                return "int";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 2: {
                return "char";
            }
            case 4: {
                return "short";
            }
            case 3: {
                return "byte";
            }
            case 10: {
                return type.getInternalName().replace('/', '.');
            }
            case 9: {
                return JavadoctorRemapper.getJavadocType(type.getElementType()) + "[]";
            }
        }
        throw new UnsupportedOperationException("Unknown type in javadoc: " + type.getSort());
    }
}

