/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraftforge.fart.api.ClassProvider;
import net.minecraftforge.fart.internal.JavadoctorRemapper;
import net.minecraftforge.srgutils.IMappingFile;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;

class EnhancedRemapper
extends Remapper {
    private final ClassProvider classProvider;
    private final IMappingFile map;
    private final Map<String, Optional<MClass>> resolved = new ConcurrentHashMap<String, Optional<MClass>>();
    private final Consumer<String> log;

    public EnhancedRemapper(ClassProvider classProvider, IMappingFile map, Consumer<String> log) {
        this.classProvider = classProvider;
        this.map = map;
        this.log = log;
    }

    public String mapModuleName(String name) {
        return name;
    }

    public String mapAnnotationAttributeName(String descriptor, String name) {
        return name;
    }

    public String mapInvokeDynamicMethodName(String name, String descriptor) {
        return name;
    }

    public String mapMethodName(String owner, String name, String descriptor) {
        return this.getClass(owner).flatMap(c -> c.getMethod(name, descriptor)).map(MClass.MMethod::getMapped).orElse(name);
    }

    public String mapRecordComponentName(String owner, String name, String descriptor) {
        return this.mapFieldName(owner, name, descriptor);
    }

    public String mapFieldName(String owner, String name, String descriptor) {
        return this.getClass(owner).flatMap(c -> c.getField(name, descriptor)).map(MClass.MField::getMapped).orElse(name);
    }

    public Optional<String> mapJavadocMember(String owner, String name, int paramCount) {
        return this.findMethod(owner, name, paramCount).map((? super T method) -> method.getMapped() + JavadoctorRemapper.getJavadocDesc(Type.getMethodType((String)this.mapMethodDesc(method.getDescriptor()))));
    }

    private Optional<MClass.MMethod> findMethod(String owner, String name, int paramCount) {
        return EnhancedRemapper.stream(this.getClass(owner)).flatMap(c -> c.getMethods().stream().flatMap(EnhancedRemapper::stream)).filter(m -> m.getName().equals(name) && Type.getMethodType((String)m.getDescriptor()).getArgumentTypes().length == paramCount).findFirst();
    }

    public String mapPackageName(String name) {
        return this.map.remapPackage(name);
    }

    public String map(String name) {
        return this.getClass(name).map(MClass::getMapped).orElse(this.map.remapClass(name));
    }

    public String mapParameterName(String owner, String methodName, String methodDescriptor, int index, String paramName) {
        return this.getClass(owner).flatMap(c -> c.getMethod(methodName, methodDescriptor)).map((? super T m) -> m.mapParameter(index, paramName)).orElse(paramName);
    }

    public Object mapValue(Object value) {
        if (value instanceof Handle) {
            Handle handle = (Handle)value;
            boolean isFieldHandle = handle.getTag() <= 4;
            return new Handle(handle.getTag(), this.mapType(handle.getOwner()), isFieldHandle ? this.mapFieldName(handle.getOwner(), handle.getName(), handle.getDesc()) : this.mapMethodName(handle.getOwner(), handle.getName(), handle.getDesc()), isFieldHandle ? this.mapDesc(handle.getDesc()) : this.mapMethodDesc(handle.getDesc()), handle.isInterface());
        }
        return super.mapValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<MClass> getClass(String cls) {
        if (cls == null || cls.charAt(0) == '[') {
            return Optional.empty();
        }
        Optional<MClass> ret = this.resolved.get(cls);
        if (ret == null) {
            String string = cls.intern();
            synchronized (string) {
                ret = this.resolved.get(cls);
                if (ret == null) {
                    ret = this.computeClass(cls);
                    this.resolved.put(cls, ret);
                }
            }
        }
        return ret;
    }

    private ClassProvider getClassProvider() {
        return this.classProvider;
    }

    private IMappingFile getMap() {
        return this.map;
    }

    private Optional<MClass> computeClass(String cls) {
        Optional<? extends ClassProvider.IClassInfo> icls = this.getClassProvider().getClass(cls);
        IMappingFile.IClass mcls = this.map.getClass(cls);
        if (!icls.isPresent() && mcls == null) {
            return Optional.empty();
        }
        return Optional.of(new MClass(icls.orElse(null), mcls));
    }

    private static <T> Stream<T> stream(Optional<T> optional) {
        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();
    }

    private class MClass {
        private final ClassProvider.IClassInfo icls;
        private final IMappingFile.IClass mcls;
        private final String mappedName;
        private final List<MClass> parents;
        private final Map<String, Optional<MField>> fields = new ConcurrentHashMap<String, Optional<MField>>();
        private Collection<Optional<MField>> fieldsView = Collections.unmodifiableCollection(this.fields.values());
        private final Map<String, Optional<MMethod>> methods = new ConcurrentHashMap<String, Optional<MMethod>>();
        private Collection<Optional<MMethod>> methodsView = Collections.unmodifiableCollection(this.methods.values());

        MClass(ClassProvider.IClassInfo icls, IMappingFile.IClass mcls) {
            if (icls == null && mcls == null) {
                throw new IllegalArgumentException("Can't pass in both nulls..");
            }
            this.icls = icls;
            this.mcls = mcls;
            String string = this.mappedName = mcls == null ? EnhancedRemapper.this.getMap().remapClass(icls.getName()) : mcls.getMapped();
            if (icls != null) {
                ArrayList parents = new ArrayList();
                EnhancedRemapper.this.getClass(icls.getSuper()).ifPresent(parents::add);
                icls.getInterfaces().stream().map(x$0 -> EnhancedRemapper.this.getClass(x$0)).forEach(o -> o.ifPresent(parents::add));
                this.parents = Collections.unmodifiableList(parents);
                icls.getFields().stream().map(f -> new MField((ClassProvider.IFieldInfo)f, mcls == null ? null : mcls.getField(f.getName()))).forEach(f -> this.fields.put(f.getKey(), Optional.of(f)));
                icls.getMethods().stream().map(m -> new MMethod((ClassProvider.IMethodInfo)m, mcls == null ? null : mcls.getMethod(m.getName(), m.getDescriptor()))).forEach(m -> this.methods.put(m.getKey(), Optional.of(m)));
            } else {
                this.parents = Collections.emptyList();
                mcls.getFields().stream().map(f -> new MField(null, (IMappingFile.IField)f)).forEach(f -> this.fields.put(f.getKey(), Optional.of(f)));
                mcls.getMethods().stream().map(m -> new MMethod(null, (IMappingFile.IMethod)m)).forEach(m -> this.methods.put(m.getKey(), Optional.of(m)));
            }
            for (MClass parentCls : this.parents) {
                for (Optional<MField> optional : parentCls.getFields()) {
                    MField fld;
                    Optional<MField> existing;
                    if (!optional.isPresent() || (existing = this.fields.get((fld = optional.get()).getKey())) != null && existing.isPresent()) continue;
                    this.fields.put(fld.getKey(), optional);
                }
                for (Optional<Object> optional : parentCls.getMethods()) {
                    if (!optional.isPresent()) continue;
                    MMethod mtd = (MMethod)optional.get();
                    if (parentCls.isInterface() && !mtd.isInterfaceInheritable()) continue;
                    Optional<MMethod> existingOpt = this.methods.get(mtd.getKey());
                    if (existingOpt == null || !existingOpt.isPresent()) {
                        this.methods.put(mtd.getKey(), optional);
                        continue;
                    }
                    MMethod existing = existingOpt.get();
                    if (!existing.hasMapping() && !existing.getName().equals(mtd.getMapped())) {
                        if (!existing.getMapped().equals(mtd.getMapped())) {
                            EnhancedRemapper.this.log.accept("Conflicting propagated mapping for " + existing + " from " + mtd + ": " + existing.getMapped() + " -> " + mtd.getMapped());
                        }
                        existing.setMapped(mtd.getMapped());
                        continue;
                    }
                    if (mtd.hasMapping() || mtd.getName().equals(existing.getMapped())) continue;
                    if (!mtd.getMapped().equals(existing.getMapped())) {
                        EnhancedRemapper.this.log.accept("Conflicting propagated mapping for " + mtd + " from " + existing + ": " + mtd.getMapped() + " -> " + existing.getMapped());
                    }
                    mtd.setMapped(existing.getMapped());
                }
            }
        }

        public String getName() {
            return this.icls != null ? this.icls.getName() : this.mcls.getOriginal();
        }

        public String getMapped() {
            return this.mappedName;
        }

        public int getAccess() {
            if (this.icls == null) {
                return 2;
            }
            return this.icls.getAccess();
        }

        public boolean isInterface() {
            return (this.getAccess() & 0x200) != 0;
        }

        public Collection<Optional<MField>> getFields() {
            return this.fieldsView;
        }

        public Optional<MField> getField(String name, @Nullable String desc) {
            if (desc == null) {
                return this.fields.computeIfAbsent(name, k -> Optional.empty());
            }
            Optional<MField> ret = this.fields.get(name + desc);
            if (ret == null) {
                ret = this.getField(name, null);
                this.fields.put(name + desc, ret);
            }
            return ret;
        }

        public Collection<Optional<MMethod>> getMethods() {
            return this.methodsView;
        }

        public Optional<MMethod> getMethod(String name, String desc) {
            return this.methods.computeIfAbsent(name + desc, k -> Optional.empty());
        }

        public String toString() {
            return this.getName();
        }

        public class MMethod {
            private final ClassProvider.IMethodInfo imtd;
            private final IMappingFile.IMethod mmtd;
            private String mappedName;
            private final String[] params;
            private final String key;

            MMethod(ClassProvider.IMethodInfo imtd, IMappingFile.IMethod mmtd) {
                this.imtd = imtd;
                this.mmtd = mmtd;
                if (mmtd != null && !mmtd.getDescriptor().contains("()")) {
                    ArrayList<String> tmp = new ArrayList<String>();
                    if ((imtd.getAccess() & 8) == 0) {
                        tmp.add("this");
                    }
                    Type[] args = Type.getArgumentTypes((String)mmtd.getDescriptor());
                    for (int x = 0; x < args.length; ++x) {
                        String name = mmtd.remapParameter(x, null);
                        tmp.add(name);
                        if (args[x].getSize() != 2) continue;
                        tmp.add(name);
                    }
                    this.params = tmp.toArray(new String[tmp.size()]);
                } else {
                    this.params = null;
                }
                this.key = this.getName() + this.getDescriptor();
            }

            public String getName() {
                return this.imtd != null ? this.imtd.getName() : this.mmtd.getOriginal();
            }

            public String getDescriptor() {
                return this.imtd != null ? this.imtd.getDescriptor() : this.mmtd.getDescriptor();
            }

            public String getMapped() {
                return this.mappedName == null ? (this.mmtd == null ? this.getName() : this.mmtd.getMapped()) : this.mappedName;
            }

            public String getKey() {
                return this.key;
            }

            public void setMapped(String name) {
                this.mappedName = name;
            }

            public boolean hasMapping() {
                return this.mmtd != null;
            }

            public int getAccess() {
                if (this.imtd == null) {
                    return 2;
                }
                return this.imtd.getAccess();
            }

            public boolean isInterfaceInheritable() {
                return (this.getAccess() & 0xA) == 0;
            }

            public String mapParameter(int index, String name) {
                return this.params != null && index >= 0 && index < this.params.length ? this.params[index] : name;
            }

            public String toString() {
                return MClass.this.getName() + '/' + this.getName() + this.getDescriptor();
            }
        }

        public class MField {
            private final ClassProvider.IFieldInfo ifld;
            private final IMappingFile.IField mfld;
            private final String mappedName;
            private final String key;

            MField(ClassProvider.IFieldInfo ifld, IMappingFile.IField mfld) {
                this.ifld = ifld;
                this.mfld = mfld;
                this.mappedName = mfld == null ? ifld.getName() : mfld.getMapped();
                this.key = this.getDescriptor() == null ? this.getName() : this.getName() + this.getDescriptor();
            }

            public String getName() {
                return this.ifld != null ? this.ifld.getName() : this.mfld.getOriginal();
            }

            public String getDescriptor() {
                return this.ifld != null ? this.ifld.getDescriptor() : this.mfld.getDescriptor();
            }

            public String getMapped() {
                return this.mappedName;
            }

            public String getKey() {
                return this.key;
            }

            public String toString() {
                return MClass.this.getName() + '/' + this.getName() + ' ' + this.getDescriptor();
            }
        }
    }
}

