/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.Expose;
import io.github.matyrobbrt.curseforgeapi.util.gson.RecordTypeAdapterFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public record PistonMeta(List<Version> versions) {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new RecordTypeAdapterFactory()).create();
    public static final Path CACHE = Path.of("meta", new String[0]);
    public static PistonMeta data = PistonMeta.resolveMeta();

    /*
     * Enabled aggressive exception aggregation
     */
    private static PistonMeta resolveMeta() {
        Path cachedPath = CACHE.resolve("piston-meta.json");
        try (InputStream is = URI.create("https://piston-meta.mojang.com/mc/game/version_manifest_v2.json").toURL().openStream();){
            PistonMeta pistonMeta;
            byte[] allBytes = is.readAllBytes();
            if (!Files.exists(cachedPath, new LinkOption[0]) || !Arrays.equals(allBytes, PistonMeta.io(() -> Files.newInputStream(cachedPath, new OpenOption[0]), InputStream::readAllBytes))) {
                Files.deleteIfExists(cachedPath);
                Files.createDirectories(cachedPath.getParent(), new FileAttribute[0]);
                Files.write(cachedPath, allBytes, new OpenOption[0]);
            }
            try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(allBytes));){
                pistonMeta = (PistonMeta)GSON.fromJson((Reader)reader, PistonMeta.class);
            }
            return pistonMeta;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static <T extends Closeable, Z> Z io(IOSupplier<T> sup, FunctionEx<T, Z> map) throws IOException {
        try (Closeable t = (Closeable)sup.get();){
            Z z = map.apply(t);
            return z;
        }
    }

    @Nullable
    public static Version getVersion(String id) {
        return PistonMeta.data.versions.stream().filter(it -> it.id.equals(id)).findFirst().orElse(null);
    }

    private static interface IOSupplier<T> {
        public T get() throws IOException;
    }

    private static interface FunctionEx<T, Z> {
        public Z apply(T var1) throws IOException;
    }

    static final class Version {
        public String id;
        public String type;
        public String url;
        public String sha1;
        @Expose(deserialize=false)
        MetaPackage metaPackage;

        Version() {
        }

        MetaPackage resolvePackage() throws IOException {
            if (this.metaPackage != null) {
                return this.metaPackage;
            }
            Path cachedPath = CACHE.resolve(this.id + ".package.json");
            try (Closeable is = URI.create(this.url).toURL().openStream();){
                if (!Files.exists(cachedPath, new LinkOption[0]) || !Arrays.equals(((InputStream)is).readAllBytes(), PistonMeta.io(() -> Files.newInputStream(cachedPath, new OpenOption[0]), InputStream::readAllBytes))) {
                    Files.deleteIfExists(cachedPath);
                    Files.createDirectories(cachedPath.getParent(), new FileAttribute[0]);
                    Files.write(cachedPath, ((InputStream)is).readAllBytes(), new OpenOption[0]);
                }
            }
            is = Files.newBufferedReader(cachedPath);
            try {
                MetaPackage metaPackage = this.metaPackage = (MetaPackage)GSON.fromJson((Reader)is, MetaPackage.class);
                return metaPackage;
            }
            finally {
                if (is != null) {
                    ((BufferedReader)is).close();
                }
            }
        }
    }

    static class MetaPackage {
        public Downloads downloads;

        MetaPackage() {
        }

        static class Download {
            public String sha1;
            public long size;
            public String url;

            Download() {
            }

            public void download(Path location) throws IOException {
                try (InputStream is = this.open();){
                    Files.deleteIfExists(location);
                    if (location.getParent() != null) {
                        Files.createDirectories(location.getParent(), new FileAttribute[0]);
                    }
                    Files.write(location, is.readAllBytes(), new OpenOption[0]);
                }
            }

            public InputStream open() throws IOException {
                return URI.create(this.url).toURL().openStream();
            }
        }

        static class Downloads {
            public Download client;
            public Download client_mappings;
            public Download server;
            public Download server_mappings;

            Downloads() {
            }
        }
    }
}

