/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.IRenamer;
import net.minecraftforge.waifu.util.PistonMeta;

public class MappingUtils {
    public static final Path CACHE = Path.of("mappings", new String[0]);

    public static IMappingFile srgToMoj(String mcVersion) throws IOException {
        IMappingFile deobfToObf;
        Path path = CACHE.resolve(mcVersion + ".srg");
        if (Files.exists(path, new LinkOption[0])) {
            return IMappingFile.load((File)path.toFile());
        }
        String downloadUrl = "https://maven.minecraftforge.net/de/oceanlabs/mcp/mcp_config/%s/mcp_config-%s.zip".formatted(mcVersion, mcVersion);
        byte[] srgMappingsData = new byte[]{};
        try (ZipInputStream is = new ZipInputStream(new URL(downloadUrl).openStream());){
            ZipEntry entry;
            while ((entry = is.getNextEntry()) != null) {
                if (!entry.getName().equals("config/joined.tsrg")) continue;
                srgMappingsData = is.readAllBytes();
            }
        }
        try (InputStream is = PistonMeta.getVersion((String)mcVersion).resolvePackage().downloads.client_mappings.open();){
            deobfToObf = IMappingFile.load((InputStream)is);
        }
        final IMappingFile obfToSrg = IMappingFile.load((InputStream)new ByteArrayInputStream(srgMappingsData));
        IMappingFile deobfToSrg = deobfToObf.rename(new IRenamer(){

            public String rename(IMappingFile.IField value) {
                return obfToSrg.getClass(((IMappingFile.IClass)value.getParent()).getMapped()).getField(value.getMapped()).getMapped();
            }

            public String rename(IMappingFile.IMethod value) {
                return obfToSrg.getClass(((IMappingFile.IClass)value.getParent()).getMapped()).getMethod(value.getMapped(), value.getMappedDescriptor()).getMapped();
            }

            public String rename(IMappingFile.IClass value) {
                return obfToSrg.getClass(value.getMapped()).getMapped();
            }
        });
        IMappingFile mappingFile = deobfToSrg.rename(new IRenamer(){

            public String rename(IMappingFile.IClass value) {
                return value.getOriginal();
            }
        }).reverse();
        mappingFile.write(path, IMappingFile.Format.TSRG, false);
        return mappingFile;
    }
}

