/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.function.IntConsumer;

public class DynamicSemaphore
extends Semaphore {
    static final VarHandle SYNC_FIELD;
    static final MethodHandle compareAndSetState;
    private final IntConsumer setter;

    public DynamicSemaphore(int permits) {
        super(permits);
        Object sync = SYNC_FIELD.get(this);
        this.setter = value -> {
            try {
                while (!compareAndSetState.invoke(sync, this.availablePermits(), value)) {
                }
                return;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    public void setPermits(int permits) {
        this.setter.accept(permits);
    }

    static {
        try {
            Field implLookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            implLookup.setAccessible(true);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)implLookup.get(null);
            Class<?> syncClass = lookup.findClass("java.util.concurrent.Semaphore$Sync");
            SYNC_FIELD = lookup.findVarHandle(Semaphore.class, "sync", syncClass);
            compareAndSetState = lookup.findVirtual(AbstractQueuedSynchronizer.class, "compareAndSetState", MethodType.methodType(Boolean.TYPE, Integer.TYPE, Integer.TYPE));
        }
        catch (Exception exception) {
            throw new RuntimeException("BARF!", exception);
        }
    }
}

