/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.collect;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public final class ModPointer {
    private final String modId;
    private final int projectId;
    private final int fileId;

    public ModPointer(String modId, int projectId, int fileId) {
        this.modId = modId;
        this.projectId = projectId;
        this.fileId = fileId;
    }

    public ModPointer(String modId) {
        this.modId = modId;
        this.projectId = 0;
        this.fileId = 0;
    }

    private ModPointer(String modId, int projectId) {
        this.modId = modId;
        this.projectId = projectId;
        this.fileId = 0;
    }

    public String getModId() {
        return this.modId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public int getFileId() {
        return this.fileId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModPointer that = (ModPointer)o;
        if (Objects.equals(this.modId, that.modId)) {
            return Objects.equals(this.projectId, that.projectId) || that.projectId == 0 || this.projectId == 0;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.modId, this.projectId);
    }

    public static final class Mapper
    implements RowMapper<ModPointer> {
        public ModPointer map(ResultSet rs, StatementContext ctx) throws SQLException {
            return new ModPointer(rs.getString("modId"), rs.getInt("projectId"));
        }
    }
}

