/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import cpw.mods.jarhandling.SecureJar;
import io.github.matyrobbrt.curseforgeapi.CurseForgeAPI;
import io.github.matyrobbrt.curseforgeapi.schemas.file.File;
import io.github.matyrobbrt.curseforgeapi.util.CurseForgeException;
import io.github.matyrobbrt.curseforgeapi.util.gson.RecordTypeAdapterFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraftforge.waifu.BotMain;
import net.minecraftforge.waifu.collect.ModPointer;
import net.minecraftforge.waifu.collect.ProgressMonitor;

public class ModCollector {
    private static final TomlParser PARSER = new TomlParser();
    public static final Path DOWNLOAD_CACHE = Path.of("cfCache", new String[0]);
    private final CurseForgeAPI api;
    private final Set<String> jarJars = new HashSet<String>();
    private final Map<ModPointer, SecureJar> jars = new HashMap<ModPointer, SecureJar>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new RecordTypeAdapterFactory()).create();

    public ModCollector(CurseForgeAPI api) {
        this.api = api;
    }

    public Map<ModPointer, SecureJar> getJarsToProcess() {
        return this.jars;
    }

    public void fromModpack(int packId, int fileId, ProgressMonitor monitor) throws CurseForgeException, IOException {
        this.fromModpack((File)this.api.getHelper().getModFile(packId, fileId).orElseThrow(), monitor);
    }

    public void fromModpack(File packFile, ProgressMonitor monitor) throws CurseForgeException, IOException {
        Manifest mf;
        Path modpackFile = this.download(packFile);
        if (modpackFile == null) {
            return;
        }
        try (FileSystem zip = FileSystems.newFileSystem(modpackFile);){
            Path manifest = zip.getPath("manifest.json", new String[0]);
            if (!Files.exists(manifest, new LinkOption[0])) {
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(manifest);){
                mf = (Manifest)GSON.fromJson((Reader)reader, Manifest.class);
            }
        }
        List<File> files = ((List)this.api.getHelper().getFiles(mf.files.stream().mapToInt(FilePointer::fileID).toArray()).orElseThrow()).stream().filter(f -> f.downloadUrl() != null).filter(BotMain.distinct(File::id)).toList();
        monitor.setDownloadTarget(files.size());
        try (ExecutorService executor = Executors.newFixedThreadPool(3, Thread.ofPlatform().name("mod-downloader", 0L).daemon(true).factory());){
            for (File file : files) {
                executor.submit(() -> {
                    try {
                        this.considerFile(file);
                    }
                    finally {
                        monitor.downloadEnded(file);
                    }
                    return null;
                });
            }
        }
    }

    public void considerFile(int projectId, int fileId) throws CurseForgeException, IOException {
        this.considerFile((File)this.api.getHelper().getModFile(projectId, fileId).orElseThrow());
    }

    public void considerFile(File file) throws IOException {
        Path downloaded = this.download(file);
        if (downloaded == null) {
            return;
        }
        this.consider(SecureJar.from((Path[])new Path[]{downloaded}), new FilePointer(file.modId(), file.id()));
    }

    @Nullable
    public Path download(File file) throws IOException {
        if (file.downloadUrl() == null) {
            return null;
        }
        Path path = DOWNLOAD_CACHE.resolve(file.modId() + "/" + file.id() + file.downloadUrl().substring(file.downloadUrl().lastIndexOf(46)));
        if (Files.exists(path, new LinkOption[0]) && Files.size(path) == (long)file.fileLength()) {
            return path;
        }
        file.download(path);
        return path;
    }

    public void consider(SecureJar jar, @Nullable FilePointer file) throws IOException {
        String modId = ModCollector.getModId(jar);
        if (modId != null) {
            if (file == null) {
                this.jars.put(new ModPointer(modId), jar);
            } else {
                this.jars.put(new ModPointer(modId, file.projectID, file.fileID), jar);
            }
        }
        this.collectJiJFrom(jar);
    }

    public void collectJiJFrom(SecureJar secureJar) throws IOException {
        Path path = secureJar.getPath("META-INF/jarjar/metadata.json", new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            JsonArray array = ((JsonObject)new Gson().fromJson((Reader)Files.newBufferedReader(path), JsonObject.class)).getAsJsonArray("jars");
            for (JsonElement element : array) {
                JsonObject obj = (JsonObject)element;
                JsonObject identifier = obj.getAsJsonObject("identifier");
                String id = identifier.get("group").getAsString() + ":" + identifier.get("artifact").getAsString();
                if (!this.jarJars.add(id)) continue;
                SecureJar jar = SecureJar.from((Path[])new Path[]{secureJar.getPath(obj.get("path").getAsString(), new String[0])});
                this.consider(jar, null);
            }
        }
    }

    @Nullable
    public static String getModId(SecureJar jar) throws IOException {
        CommentedConfig config;
        List mods;
        Path path = jar.getPath("META-INF", new String[]{"mods.toml"});
        if (Files.exists(path, new LinkOption[0]) && !(mods = (List)(config = PARSER.parse((Reader)Files.newBufferedReader(path))).get("mods")).isEmpty()) {
            return (String)((CommentedConfig)mods.get(0)).get("modId");
        }
        return null;
    }

    record Manifest(List<FilePointer> files) {
    }

    record FilePointer(int projectID, int fileID) {
    }
}

