/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class SavedTrackedData<T> {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final Object lock = new Object();
    private final Type type;
    private final Supplier<T> defaultValue;
    private final Path path;
    private T value;

    public SavedTrackedData(TypeToken<T> type, Supplier<T> defaultValue, Path path) {
        this.type = type.getType();
        this.defaultValue = defaultValue;
        this.path = path;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Z> Z withHandle(Function<T, Z> handler) {
        Object object = this.lock;
        synchronized (object) {
            this.refresh();
            Z z = handler.apply(this.value);
            this.write();
            return z;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useHandle(Consumer<T> handler) {
        Object object = this.lock;
        synchronized (object) {
            this.refresh();
            handler.accept(this.value);
            this.write();
        }
    }

    public T read() {
        this.refresh();
        return this.value;
    }

    private void refresh() {
        block9: {
            try {
                if (!Files.exists(this.path, new LinkOption[0])) {
                    Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                    this.value = this.defaultValue.get();
                    Files.writeString(this.path, (CharSequence)GSON.toJson(this.value, this.type), new OpenOption[0]);
                    break block9;
                }
                try (BufferedReader reader = Files.newBufferedReader(this.path);){
                    this.value = GSON.fromJson((Reader)reader, this.type);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not refresh tracked value at " + String.valueOf(this.path.toAbsolutePath()), ex);
            }
        }
    }

    public void write() {
        try {
            Files.writeString(this.path, (CharSequence)GSON.toJson(this.value, this.type), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write tracked value at " + String.valueOf(this.path.toAbsolutePath()), e);
        }
    }
}

