/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.util;

import java.util.HashMap;
import net.minecraftforge.srgutils.IMappingFile;

public interface Remapper {
    public String remapMethod(String var1);

    public String remapField(String var1);

    public static Remapper fromMappings(IMappingFile file) {
        final HashMap srgMethods = new HashMap();
        final HashMap srgFields = new HashMap();
        file.getClasses().forEach(clazz -> {
            clazz.getMethods().forEach(method -> {
                if (method.getOriginal().startsWith("m_")) {
                    srgMethods.put(method.getOriginal(), method.getMapped());
                }
            });
            clazz.getFields().forEach(fields -> {
                if (fields.getOriginal().startsWith("f_")) {
                    srgFields.put(fields.getOriginal(), fields.getMapped());
                }
            });
        });
        return new Remapper(){

            @Override
            public String remapMethod(String name) {
                return srgMethods.getOrDefault(name, name);
            }

            @Override
            public String remapField(String name) {
                return srgFields.getOrDefault(name, name);
            }
        };
    }
}

