/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.LayoutBase;
import java.util.Map;
import org.slf4j.Marker;

public class DiscordLogbackLayout
extends LayoutBase<ILoggingEvent> {
    private static final String UNKNOWN_EMOTE = ":radio_button:";
    public static final Map<Level, String> LEVEL_TO_EMOTE = Map.of(Level.ERROR, ":red_square:", Level.WARN, ":yellow_circle:", Level.INFO, ":white_medium_small_square:", Level.DEBUG, ":large_blue_diamond:", Level.TRACE, ":small_orange_diamond:");
    private static final int MAXIMUM_STACKTRACE_LENGTH = 1750;

    public String doLayout(ILoggingEvent event) {
        StringBuilder builder = new StringBuilder(2000);
        builder.append(LEVEL_TO_EMOTE.getOrDefault(event.getLevel(), UNKNOWN_EMOTE)).append(" [**").append(event.getLoggerName());
        if (event.getMarkerList() != null && !event.getMarkerList().isEmpty()) {
            builder.append("**/**").append(((Marker)event.getMarkerList().get(0)).getName());
        }
        builder.append("**] - ").append(event.getFormattedMessage()).append(System.lineSeparator());
        if (event.getThrowableProxy() != null) {
            IThrowableProxy t = event.getThrowableProxy();
            builder.append(t.getClassName()).append(": ").append(t.getMessage()).append(System.lineSeparator());
            StringBuilder stacktrace = this.buildStacktrace(t);
            String stacktraceCutoff = null;
            builder.append("Stacktrace: ");
            if (stacktrace.length() > 1750) {
                stacktraceCutoff = stacktrace.substring(1750, stacktrace.length());
                stacktrace.delete(1750, stacktrace.length());
            }
            builder.append(System.lineSeparator()).append("```ansi").append(System.lineSeparator()).append((CharSequence)stacktrace).append("```");
            if (stacktraceCutoff != null) {
                builder.append("*Too long to fully display. ").append(stacktraceCutoff.length()).append(" characters or ").append(stacktraceCutoff.lines().count()).append(" lines were truncated.*");
            }
        }
        return builder.toString();
    }

    private StringBuilder buildStacktrace(IThrowableProxy exception) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElementProxy element : exception.getStackTraceElementProxyArray()) {
            builder.append("\t ").append(element.toString()).append(System.lineSeparator());
        }
        return builder;
    }
}

