/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.logback;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import java.util.List;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.minecraftforge.waifu.logback.DiscordLogbackLayout;
import org.slf4j.LoggerFactory;

public class DiscordLogbackAppender
extends AppenderBase<ILoggingEvent> {
    private Layout<ILoggingEvent> layout;
    private MessageChannel channel;

    public void setup(Layout<ILoggingEvent> layout, MessageChannel channel) {
        this.layout = layout;
        this.channel = channel;
    }

    public static void setup(@Nullable MessageChannel channel) throws ClassCastException {
        if (channel == null) {
            return;
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        DiscordLogbackLayout layout = new DiscordLogbackLayout();
        layout.setContext((Context)context);
        layout.start();
        Logger rootLogger = context.getLogger("ROOT");
        ((DiscordLogbackAppender)rootLogger.getAppender("DISCORD")).setup((Layout<ILoggingEvent>)layout, channel);
    }

    protected void append(ILoggingEvent eventObject) {
        if (this.channel == null) {
            return;
        }
        ((MessageCreateAction)this.channel.sendMessage((CharSequence)this.getMessageContent(eventObject)).setAllowedMentions(List.of())).queue();
    }

    protected String getMessageContent(ILoggingEvent event) {
        return this.layout != null ? this.layout.doLayout((Object)event) : event.getFormattedMessage();
    }
}

