/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.collect;

import com.google.common.base.Stopwatch;
import io.github.matyrobbrt.curseforgeapi.schemas.file.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.dv8tion.jda.api.entities.Message;
import net.minecraftforge.waifu.collect.ProgressMonitor;
import org.jetbrains.annotations.Nullable;

public class DiscordProgressMonitor
implements ProgressMonitor {
    private final Message loggingMessage;
    private final String initialMessage;
    private final BiConsumer<String, Exception> exceptionallyConsumer;
    private final AtomicInteger numberOfMods;
    private final AtomicInteger completed;
    private final List<String> currentMods;
    private final Map<String, Exception> exceptionally;
    private final AtomicInteger toDownload = new AtomicInteger();
    private final AtomicInteger downloaded = new AtomicInteger(-1);

    public DiscordProgressMonitor(Message loggingMessage, BiConsumer<String, Exception> exceptionallyConsumer) {
        this.loggingMessage = loggingMessage;
        this.initialMessage = loggingMessage.getContentRaw();
        this.exceptionallyConsumer = exceptionallyConsumer;
        this.numberOfMods = new AtomicInteger(-1);
        this.completed = new AtomicInteger();
        this.currentMods = new ArrayList<String>();
        this.exceptionally = new HashMap<String, Exception>();
        this.setupMonitor();
    }

    public void markCollection(int fileAmount) {
        this.loggingMessage.editMessage((CharSequence)(this.initialMessage + ":\n" + (String)(fileAmount == -1 ? "Collecting mods." : "Collecting mods from " + fileAmount + " files."))).complete();
    }

    private void setupMonitor() {
        Stopwatch start = Stopwatch.createStarted();
        ForkJoinPool.commonPool().submit(() -> {
            long monitoringInterval = Duration.ofSeconds(2L).toMillis();
            AtomicLong last = new AtomicLong(System.currentTimeMillis());
            while (true) {
                if (System.currentTimeMillis() - last.get() < monitoringInterval) {
                    continue;
                }
                last.set(System.currentTimeMillis());
                int num = this.numberOfMods.get();
                int com = this.completed.get();
                StringBuilder content = new StringBuilder().append(this.initialMessage).append(":\n");
                boolean breakOut = false;
                if (num == -1) {
                    int toDown = this.toDownload.get();
                    if (toDown == -1 || toDown == this.downloaded.get()) continue;
                    if (toDown == 0) {
                        content.append("Found no mods to download!");
                        breakOut = true;
                    } else {
                        content.append("Downloading mods... Currently downloaded ").append(this.downloaded.get()).append("/").append(toDown).append(".");
                    }
                } else if (num == com) {
                    content.append("Completed scanning of ").append(num).append(" mods in ").append(start.stop().elapsed(TimeUnit.SECONDS)).append(" seconds!");
                    breakOut = true;
                } else {
                    List<String> list = this.currentMods;
                    synchronized (list) {
                        if (this.currentMods.isEmpty()) {
                            content.append("Currently idling...");
                        } else {
                            content.append(IntStream.range(0, this.currentMods.size()).mapToObj(i -> "- " + this.currentMods.get(i) + " (" + (com + i + 1) + "/" + num + ")").collect(Collectors.joining("\n")));
                        }
                    }
                }
                Map<String, Exception> map = this.exceptionally;
                synchronized (map) {
                    if (!this.exceptionally.isEmpty()) {
                        content.append("\n\u274c Completed exceptionally:").append(String.join((CharSequence)", ", this.exceptionally.keySet()));
                    }
                }
                this.loggingMessage.editMessage((CharSequence)content.toString()).complete();
                if (breakOut) break;
            }
        });
    }

    @Override
    public void setNumberOfMods(int numberOfMods) {
        this.numberOfMods.set(numberOfMods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startMod(String id) {
        List<String> list = this.currentMods;
        synchronized (list) {
            this.currentMods.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedMod(String id, @Nullable Exception exception) {
        List<String> list = this.currentMods;
        synchronized (list) {
            this.currentMods.remove(id);
            this.completed.incrementAndGet();
            if (exception != null) {
                Map<String, Exception> map = this.exceptionally;
                synchronized (map) {
                    this.exceptionally.put(id, exception);
                    this.exceptionallyConsumer.accept(id, exception);
                }
            }
        }
    }

    @Override
    public void downloadEnded(File file) {
        this.downloaded.incrementAndGet();
    }

    @Override
    public void setDownloadTarget(int downloadTarget) {
        this.toDownload.set(downloadTarget);
    }
}

