/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu;

import com.google.gson.JsonElement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraftforge.metabase.MetabaseClient;
import net.minecraftforge.metabase.params.DatabaseInclusion;
import net.minecraftforge.metabase.params.FieldValues;
import net.minecraftforge.metabase.types.Field;
import net.minecraftforge.metabase.types.Table;
import net.minecraftforge.waifu.BotMain;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.output.MigrateResult;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.AbstractArgumentFactory;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;

public class Database {
    public static void updateMetabase(MetabaseClient client, String schemaName) {
        String[] fullUrl = System.getProperty("metabase.db").split("/", 2);
        CompletableFuture.allOf(new CompletableFuture[]{((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)client.getDatabases(UnaryOperator.identity()).thenApply(databases -> databases.stream().filter(db -> db.details() != null && Database.stringEquals(db.details().get("host"), fullUrl[0]) && Database.stringEquals(db.details().get("dbname"), fullUrl[1])))).thenApply(db -> (net.minecraftforge.metabase.types.Database)db.findFirst().orElseThrow())).thenCompose(db -> db.syncSchema().thenCompose($ -> client.getDatabase(db.id(), p -> p.include(DatabaseInclusion.TABLES_AND_FIELDS))))).thenApply(db -> db.tables().stream().filter(tb -> tb.schema().equals(schemaName)).toList())).thenCompose(tbs -> CompletableFuture.allOf((CompletableFuture[])tbs.stream().map(tb -> {
            if (tb.name().equals("flyway_schema_history")) {
                return tb.setHidden(true);
            }
            return tb.update(p -> switch (tb.name()) {
                case "refs" -> p.withDisplayName("References").withDescription("References of fields, methods, classes and annotations");
                case "inheritance" -> p.withDescription("The class hierarchy of mods");
                case "projects" -> p.withDescription("The IDs of the projects that are tracked by this schema");
                case "modids" -> p.withDisplayName("Mod IDs").withDescription("A mapping of text mod IDs to integers in order to save space");
                default -> null;
            });
        }).toArray(CompletableFuture[]::new)).thenApply($ -> tbs))).thenCompose(tbs -> {
            Table modids = tbs.stream().filter(tb -> tb.name().equals("modids")).findFirst().orElseThrow();
            Field target = modids.fields().stream().filter(f -> f.name().equals("modid")).findFirst().orElseThrow();
            return CompletableFuture.allOf((CompletableFuture[])tbs.stream().filter(tb -> tb.name().equals("inheritance") || tb.name().equals("refs")).map(tb -> tb.fields().stream().filter(f -> f.name().equals("modid")).findFirst().orElseThrow().update(u -> u.setTarget(target).withFieldValues(FieldValues.SEARCH)).thenCompose(f -> f.setDimension(target.id(), "Mod ID"))).toArray(CompletableFuture[]::new));
        })}).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                BotMain.LOGGER.error("Could not update metabase schema: ", throwable);
            }
        });
    }

    public static Map.Entry<MigrateResult, Jdbi> createDatabaseConnection(String schemaName) {
        Flyway flyway = Flyway.configure().dataSource(System.getProperty("db.url") + "?socketTimeout=0&tcpKeepAlive=true&options=-c%20statement_timeout=1h", System.getProperty("db.user"), System.getProperty("db.password")).locations(new String[]{"classpath:db"}).schemas(new String[]{schemaName}).load();
        MigrateResult result = flyway.migrate();
        return Map.entry(result, ((Jdbi)Jdbi.create(() -> {
            Connection connection = Database.initiateDBConnection();
            connection.setSchema(schemaName);
            return connection;
        }).registerArgument((ArgumentFactory)new AbstractArgumentFactory<AtomicInteger>(4){

            protected Argument build(AtomicInteger value, ConfigRegistry config) {
                return (position, statement, ctx) -> statement.setInt(position, value.get());
            }
        })).installPlugin((JdbiPlugin)new SqlObjectPlugin()));
    }

    public static Connection initiateDBConnection() throws SQLException {
        String user = System.getProperty("db.user");
        String password = System.getProperty("db.password");
        String url = System.getProperty("db.url");
        return DriverManager.getConnection(url + "?user=" + user + "&password=" + password);
    }

    private static boolean stringEquals(@Nullable JsonElement element, String str) {
        return element != null && element.getAsString().equals(str);
    }
}

