/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.statement.internal.ResultReturner;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class MapToFactory
implements SqlStatementCustomizerFactory {
    @Override
    public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
        return (stmt, arg) -> {
            QualifiedType<?> mapTo;
            if (arg instanceof QualifiedType) {
                mapTo = (QualifiedType<?>)arg;
            } else if (arg instanceof GenericType) {
                mapTo = QualifiedType.of(((GenericType)arg).getType());
            } else if (arg instanceof Type) {
                mapTo = QualifiedType.of((Type)arg);
            } else {
                throw new UnsupportedOperationException("@MapTo must take a GenericType, QualifiedType, or Type, but got a " + arg.getClass().getName());
            }
            ResultReturner returner = ResultReturner.forMethod(sqlObjectType, method);
            stmt.getConfig(SqlObjectStatementConfiguration.class).setReturner(() -> returner.mappedResult(((ResultBearing)((Object)stmt)).mapTo(mapTo), stmt.getContext()));
        };
    }
}

