/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlCall;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlScript;
import org.jdbi.v3.sqlobject.statement.SqlScripts;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public class SqlAnnotations {
    private SqlAnnotations() {
        throw new UtilityClassException();
    }

    public static Optional<String> getAnnotationValue(Method method) {
        return SqlAnnotations.getAnnotationValue(method, value -> value.isEmpty() ? null : value);
    }

    public static Optional<String> getAnnotationValue(Method method, Function<String, String> transformation) {
        return JdbiOptionals.findFirstPresent(() -> Optional.ofNullable(method.getAnnotation(SqlBatch.class)).map(SqlBatch::value).map(transformation), () -> Optional.ofNullable(method.getAnnotation(SqlCall.class)).map(SqlCall::value).map(transformation), () -> Optional.ofNullable(method.getAnnotation(SqlQuery.class)).map(SqlQuery::value).map(transformation), () -> Optional.ofNullable(method.getAnnotation(SqlUpdate.class)).map(SqlUpdate::value).map(transformation), () -> Optional.ofNullable(method.getAnnotation(SqlScripts.class)).map(SqlScripts::value).map(scripts -> Arrays.stream(scripts).map(SqlScript::value).map(transformation).collect(Collectors.joining(" ; "))), () -> Optional.ofNullable(method.getAnnotation(SqlScript.class)).map(SqlScript::value).map(transformation));
    }
}

