/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdbi.v3.sqlobject.customizer.BindMap;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

public class BindMapFactory
implements SqlStatementCustomizerFactory {
    @Override
    public SqlStatementParameterCustomizer createForParameter(Annotation a, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
        BindMap annotation = (BindMap)a;
        List<String> keys2 = Arrays.asList(annotation.keys());
        String prefix = annotation.value().isEmpty() ? "" : annotation.value() + ".";
        return (stmt, arg) -> {
            Map map = (Map)arg;
            HashMap toBind = new HashMap();
            map.forEach((k, v) -> {
                if (annotation.convertKeys() || k instanceof String) {
                    String key = k.toString();
                    if (keys2.isEmpty() || keys2.contains(key)) {
                        toBind.put(prefix + key, v);
                    }
                } else {
                    throw new IllegalArgumentException("Key " + k + " (of " + k.getClass() + ") must be a String");
                }
            });
            keys2.forEach(key -> toBind.putIfAbsent(prefix + key, null));
            stmt.bindMap(toBind);
        };
    }
}

