/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.jdbi.v3.core.internal.IterableLike;
import org.jdbi.v3.sqlobject.customizer.BindBeanList;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

public final class BindBeanListFactory
implements SqlStatementCustomizerFactory {
    @Override
    public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
        BindBeanList bindBeanList = (BindBeanList)annotation;
        String name = ParameterUtil.findParameterName(bindBeanList.value(), param).orElseThrow(() -> new UnsupportedOperationException("A @BindBeanList parameter was not given a name, and parameter name data is not present in the class file, for: " + param.getDeclaringExecutable() + "::" + param));
        return (stmt, arg) -> {
            if (arg == null) {
                throw new IllegalArgumentException("argument is null; null was explicitly forbidden on BindBeanList");
            }
            stmt.bindBeanList(name, IterableLike.toList(arg), Arrays.asList(bindBeanList.propertyNames()));
        };
    }
}

