/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.sqlobject.BridgeMethodHandlerFactory;
import org.jdbi.v3.sqlobject.DefaultMethodHandlerFactory;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.SqlMethodHandlerFactory;
import org.jdbi.v3.sqlobject.WithHandleMethodHandlerFactory;

public class Handlers
implements JdbiConfig<Handlers> {
    private final List<HandlerFactory> factories = new CopyOnWriteArrayList<HandlerFactory>();

    public Handlers() {
        this.register(new DefaultMethodHandlerFactory());
        this.register(new WithHandleMethodHandlerFactory());
        this.register(new SqlMethodHandlerFactory());
        this.register(new BridgeMethodHandlerFactory());
    }

    private Handlers(Handlers that) {
        this.factories.addAll(that.factories);
    }

    public Handlers register(HandlerFactory factory2) {
        this.factories.add(0, factory2);
        return this;
    }

    public Optional<Handler> findFor(Class<?> sqlObjectType, Method method) {
        return this.factories.stream().flatMap(factory2 -> JdbiOptionals.stream(factory2.buildHandler(sqlObjectType, method))).findFirst();
    }

    @Override
    public Handlers createCopy() {
        return new Handlers(this);
    }

    static Method methodLookup(Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        try {
            return klass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(String.format("can't find %s#%s%s", klass.getName(), methodName, Arrays.asList(parameterTypes)), e);
        }
    }
}

