/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.sqlobject.Handler;

class DefaultMethodHandler
implements Handler {
    private static final int ANY_ACCESS = 15;
    private static final Method PRIVATE_LOOKUP_IN = DefaultMethodHandler.privateLookupIn();
    private static final Map<Class<?>, MethodHandles.Lookup> PRIVATE_LOOKUPS = Collections.synchronizedMap(new WeakHashMap());
    private final MethodHandle methodHandle;

    DefaultMethodHandler(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        this.methodHandle = Unchecked.biFunction(DefaultMethodHandler.lookupFor(declaringClass)::unreflectSpecial).apply(method, declaringClass);
    }

    @Override
    public Object invoke(Object target, Object[] args2, HandleSupplier handle) {
        return Unchecked.function(this.methodHandle.bindTo(target)::invokeWithArguments).apply(args2);
    }

    private static Method privateLookupIn() {
        try {
            return MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }

    static MethodHandles.Lookup lookupFor(Class<?> clazz) {
        if (PRIVATE_LOOKUP_IN != null) {
            try {
                return (MethodHandles.Lookup)PRIVATE_LOOKUP_IN.invoke(null, clazz, MethodHandles.lookup());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                String message = String.format("Error invoking MethodHandles.privateLookupIn(%s.class, MethodHandles.lookup()) in JDK 9+ runtime", clazz);
                throw new RuntimeException(message, e);
            }
        }
        return PRIVATE_LOOKUPS.computeIfAbsent(clazz, Unchecked.function(DefaultMethodHandler::getConstructorLookup));
    }

    private static MethodHandles.Lookup getConstructorLookup(Class<?> type) throws ReflectiveOperationException {
        Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return (MethodHandles.Lookup)constructor.newInstance(type, 15);
    }
}

