/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.SQLException;
import java.time.Duration;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.StatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4JSqlLogger
implements SqlLogger {
    private final Logger log;

    public Slf4JSqlLogger() {
        this(LoggerFactory.getLogger("org.jdbi.sql"));
    }

    public Slf4JSqlLogger(Logger log) {
        this.log = log;
    }

    @Override
    public void logAfterExecution(StatementContext context) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executed in {} '{}' with parameters '{}'", Slf4JSqlLogger.format(Duration.between(context.getExecutionMoment(), context.getCompletionMoment())), Slf4JSqlLogger.getSql(context), context.getBinding());
        }
    }

    @Override
    public void logException(StatementContext context, SQLException ex) {
        if (this.log.isErrorEnabled()) {
            this.log.error("Exception while executing '{}' with parameters '{}'", Slf4JSqlLogger.getSql(context), context.getBinding(), ex);
        }
    }

    private static String getSql(StatementContext context) {
        ParsedSql parsedSql = context.getParsedSql();
        if (parsedSql != null) {
            return parsedSql.getSql();
        }
        return "<not available>";
    }

    private static String format(Duration duration) {
        long totalSeconds = duration.getSeconds();
        long h2 = totalSeconds / 3600L;
        long m4 = totalSeconds % 3600L / 60L;
        long s2 = totalSeconds % 60L;
        long ms = duration.toMillis() % 1000L;
        return String.format("%d:%02d:%02d.%03d", h2, m4, s2, ms);
    }
}

