/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.statement.CallableStatementMapper;
import org.jdbi.v3.core.statement.OutParameters;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;

public class Call
extends SqlStatement<Call> {
    private final List<OutParamArgument> params = new ArrayList<OutParamArgument>();

    public Call(Handle handle, String sql) {
        super(handle, sql);
    }

    @Override
    PreparedStatement createStatement(StatementContext ctx, ParsedSql parsedSql) throws SQLException {
        return this.getHandle().getStatementBuilder().createCall(this.getHandle().getConnection(), parsedSql.getSql(), ctx);
    }

    public Call registerOutParameter(int position, int sqlType) {
        return this.registerOutParameter(position, sqlType, null);
    }

    public Call registerOutParameter(int position, int sqlType, CallableStatementMapper mapper) {
        this.getBinding().addPositional(position, new OutParamArgument(sqlType, mapper, null));
        return this;
    }

    public Call registerOutParameter(String name, int sqlType) {
        return this.registerOutParameter(name, sqlType, null);
    }

    public Call registerOutParameter(String name, int sqlType, CallableStatementMapper mapper) {
        this.getBinding().addNamed(name, new OutParamArgument(sqlType, mapper, name));
        return this;
    }

    public OutParameters invoke() {
        return (OutParameters)this.invoke(Function.identity());
    }

    public void invoke(Consumer<OutParameters> resultConsumer) {
        this.invoke((OutParameters r) -> {
            resultConsumer.accept((OutParameters)r);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T invoke(Function<OutParameters, T> resultComputer) {
        try {
            this.internalExecute();
            OutParameters out = new OutParameters(this.getContext());
            for (OutParamArgument param : this.params) {
                Object obj = param.map((CallableStatement)this.stmt);
                int index = param.position - 1;
                out.getMap().put(index, obj);
                if (param.name == null) continue;
                out.getMap().put(param.name, obj);
            }
            Iterator<OutParamArgument> iterator2 = resultComputer.apply(out);
            return (T)iterator2;
        }
        finally {
            this.close();
        }
    }

    private class OutParamArgument
    implements Argument {
        private final int sqlType;
        private final CallableStatementMapper mapper;
        private final String name;
        private int position;

        OutParamArgument(int sqlType, CallableStatementMapper mapper, String name) {
            this.sqlType = sqlType;
            this.mapper = mapper;
            this.name = name;
            Call.this.params.add(this);
        }

        @Override
        public void apply(int outPosition, PreparedStatement statement, StatementContext ctx) throws SQLException {
            ((CallableStatement)statement).registerOutParameter(outPosition, this.sqlType);
            this.position = outPosition;
        }

        public Object map(CallableStatement stmt) {
            try {
                if (this.mapper != null) {
                    return this.mapper.map(this.position, stmt);
                }
                switch (this.sqlType) {
                    case -16: 
                    case -9: 
                    case -1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        return stmt.getString(this.position);
                    }
                    case -3: 
                    case 2004: {
                        return stmt.getBytes(this.position);
                    }
                    case 5: {
                        return stmt.getShort(this.position);
                    }
                    case 4: {
                        return stmt.getInt(this.position);
                    }
                    case -5: {
                        return stmt.getLong(this.position);
                    }
                    case 92: 
                    case 93: {
                        return stmt.getTimestamp(this.position);
                    }
                    case 91: {
                        return stmt.getDate(this.position);
                    }
                    case 6: {
                        return Float.valueOf(stmt.getFloat(this.position));
                    }
                    case 3: 
                    case 8: {
                        return stmt.getDouble(this.position);
                    }
                }
                return stmt.getObject(this.position);
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Could not get OUT parameter from statement", e, Call.this.getContext());
            }
        }
    }
}

