/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.result.ResultSetResultIterator;
import org.jdbi.v3.core.result.StreamCallback;
import org.jdbi.v3.core.result.StreamConsumer;
import org.jdbi.v3.core.statement.StatementContext;

@FunctionalInterface
public interface ResultIterable<T>
extends Iterable<T> {
    public static <T> ResultIterable<T> of(Supplier<ResultSet> supplier, RowMapper<T> mapper, StatementContext ctx) {
        return () -> {
            try {
                return new ResultSetResultIterator((ResultSet)supplier.get(), mapper, ctx);
            }
            catch (SQLException e) {
                try {
                    ctx.close();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
                throw new ResultSetException("Unable to iterator result set", e, ctx);
            }
        };
    }

    public static <T> ResultIterable<T> of(ResultIterator<T> iterator2) {
        return () -> iterator2;
    }

    @Override
    public ResultIterator<T> iterator();

    default public <R> ResultIterable<R> map(final Function<? super T, ? extends R> mapper) {
        return () -> new ResultIteratorDelegate<T, R>((ResultIterator)this.iterator()){

            @Override
            public R next() {
                return mapper.apply(this.getDelegate().next());
            }
        };
    }

    @Override
    default public void forEach(Consumer<? super T> action) {
        this.forEachWithCount(action);
    }

    default public int forEachWithCount(Consumer<? super T> action) {
        Objects.requireNonNull(action, "Action required");
        try (Iterator iter = this.iterator();){
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                action.accept(iter.next());
            }
            int n = count;
            return n;
        }
    }

    default public T one() {
        try (Iterator iter = this.iterator();){
            if (!iter.hasNext()) {
                throw new IllegalStateException("Expected one element, but found none");
            }
            Object r = iter.next();
            if (iter.hasNext()) {
                throw new IllegalStateException("Expected one element, but found multiple");
            }
            Object e = r;
            return (T)e;
        }
    }

    default public Optional<T> findOne() {
        try (Iterator iter = this.iterator();){
            if (!iter.hasNext()) {
                Optional optional = Optional.empty();
                return optional;
            }
            Object r = iter.next();
            if (iter.hasNext()) {
                throw new IllegalStateException("Expected zero to one elements, but found multiple");
            }
            Optional optional = Optional.ofNullable(r);
            return optional;
        }
    }

    @Deprecated
    default public T findOnly() {
        return this.one();
    }

    default public T first() {
        try (Iterator iter = this.iterator();){
            if (!iter.hasNext()) {
                throw new IllegalStateException("Expected at least one element, but found none");
            }
            Object e = iter.next();
            return (T)e;
        }
    }

    default public Optional<T> findFirst() {
        try (Iterator iter = this.iterator();){
            Optional optional = iter.hasNext() ? Optional.ofNullable(iter.next()) : Optional.empty();
            return optional;
        }
    }

    default public Stream<T> stream() {
        Iterator iterator2 = this.iterator();
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator2, 0), false).onClose(((ResultIterator)iterator2)::close);
    }

    default public <X extends Exception> void useStream(StreamConsumer<T, X> consumer) throws X {
        this.withStream(stream -> {
            consumer.useStream(stream);
            return null;
        });
    }

    default public <R, X extends Exception> R withStream(StreamCallback<T, R, X> callback) throws X {
        try (Stream<T> stream = this.stream();){
            R r = callback.withStream(stream);
            return r;
        }
    }

    default public List<T> list() {
        return this.collect(Collectors.toList());
    }

    default public <R> R collect(Collector<? super T, ?, R> collector) {
        try (Stream<? super T> stream = this.stream();){
            R r = stream.collect(collector);
            return r;
        }
    }

    default public <U> U reduce(U identity, BiFunction<U, T, U> accumulator) {
        try (Stream<T> stream = this.stream();){
            U u2 = stream.reduce(identity, accumulator, (u, v) -> {
                throw new UnsupportedOperationException("parallel operation not supported");
            });
            return u2;
        }
    }

    default public ResultIterable<T> filter(final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "Filter required");
        return () -> new ResultIteratorDelegate<T, T>((ResultIterator)this.iterator()){
            private T next;

            @Override
            public boolean hasNext() {
                return this.next != null || this.findNext();
            }

            @Override
            public T next() {
                if (this.next == null && !this.findNext()) {
                    throw new NoSuchElementException("No more filtered results");
                }
                Object n = this.next;
                this.next = null;
                return n;
            }

            private boolean findNext() {
                this.next = null;
                while (this.getDelegate().hasNext()) {
                    Object n = this.getDelegate().next();
                    if (!predicate.test(n)) continue;
                    this.next = n;
                    return true;
                }
                return false;
            }
        };
    }

    public static abstract class ResultIteratorDelegate<T, R>
    implements ResultIterator<R> {
        private final ResultIterator<T> delegate;

        ResultIteratorDelegate(ResultIterator<T> del) {
            this.delegate = Objects.requireNonNull(del, "Delegate required");
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public final void close() {
            this.delegate.close();
        }

        @Override
        public final StatementContext getContext() {
            return this.delegate.getContext();
        }

        protected final ResultIterator<T> getDelegate() {
            return this.delegate;
        }
    }
}

