/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.interceptor;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jdbi.v3.core.interceptor.JdbiInterceptionChain;
import org.jdbi.v3.core.interceptor.JdbiInterceptor;
import org.jdbi.v3.meta.Alpha;

@Alpha
public final class JdbiInterceptionChainHolder<S, T> {
    private static final Function<?, ?> DEFAULT_TRANSFORMER = source2 -> {
        if (source2 == null) {
            throw new UnsupportedOperationException("null value is not supported");
        }
        throw new UnsupportedOperationException("object type '" + source2.getClass().getSimpleName() + "' is not supported");
    };
    private final List<JdbiInterceptor<S, T>> interceptors = new CopyOnWriteArrayList<JdbiInterceptor<S, T>>();
    private Function<S, T> defaultTransformer;

    public JdbiInterceptionChainHolder(Function<S, T> defaultTransformer) {
        this.defaultTransformer = Objects.requireNonNull(defaultTransformer, "defaultTransformer is null");
    }

    public JdbiInterceptionChainHolder() {
        this.defaultTransformer = DEFAULT_TRANSFORMER;
    }

    @Nonnull
    public T process(@Nullable S source2) {
        ChainInstance instance = new ChainInstance(source2);
        Object result = instance.next();
        Objects.requireNonNull(result, "chain returned null value for '" + source2 + "'");
        return result;
    }

    public void addFirst(JdbiInterceptor<S, T> interceptor) {
        Objects.requireNonNull(interceptor, "interceptor is null");
        this.interceptors.add(0, interceptor);
    }

    public void addLast(JdbiInterceptor<S, T> interceptor) {
        Objects.requireNonNull(interceptor, "interceptor is null");
        this.interceptors.add(interceptor);
    }

    public void copy(JdbiInterceptionChainHolder<S, T> chainHolder) {
        Objects.requireNonNull(chainHolder, "chainHolder is null");
        this.interceptors.clear();
        this.interceptors.addAll(chainHolder.interceptors);
        this.defaultTransformer = chainHolder.defaultTransformer;
    }

    final class ChainInstance
    implements JdbiInterceptionChain<T> {
        private final Iterator<JdbiInterceptor<S, T>> iterator;
        private final S source;

        ChainInstance(S source2) {
            this.source = source2;
            this.iterator = JdbiInterceptionChainHolder.this.interceptors.iterator();
        }

        @Override
        public T next() {
            if (this.iterator.hasNext()) {
                JdbiInterceptor interceptor = this.iterator.next();
                return interceptor.intercept(this.source, this);
            }
            return JdbiInterceptionChainHolder.this.defaultTransformer.apply(this.source);
        }
    }
}

