/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.IOUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class FileUtils {
    public static String getFilename(String path) {
        if (StringUtils.hasText(path)) {
            return path.substring(path.replace("/", "\\").lastIndexOf("\\") + 1);
        }
        return "";
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        FileUtils.copy(in, out);
        String str = out.toString();
        if (str.startsWith("\ufeff")) {
            return str.substring(1);
        }
        return str;
    }

    public static String copyToString(InputStream in, Charset encoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        FileUtils.copy(in, out);
        return out.toString(encoding.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader in, Writer out) throws IOException {
        try {
            int bytesRead;
            char[] buffer = new char[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        finally {
            IOUtils.close(in);
            IOUtils.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        try {
            int bytesRead;
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            IOUtils.close(in);
            IOUtils.close(out);
        }
    }

    public static String readAsString(Path path) {
        try {
            return String.join((CharSequence)System.lineSeparator(), Files.readAllLines(path.toAbsolutePath()));
        }
        catch (IOException ioe) {
            throw new FlywayException("Unable to read " + path.toAbsolutePath() + " from disk", ioe);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readResourceAsString(String path) {
        try (InputStream inputStream2 = FileUtils.class.getClassLoader().getResourceAsStream(path);){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2));){
                String result = "";
                while (reader.ready()) {
                    result = result + reader.readLine() + System.lineSeparator();
                }
                string = result;
            }
            return string;
        }
        catch (IOException ioe) {
            throw new FlywayException("Unable to read " + path + " from resources", ioe);
        }
    }

    private FileUtils() {
    }
}

