/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.schemahistory;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.MigrationPattern;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.extensibility.AppliedMigration;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.core.internal.info.MigrationInfoContext;

public class BaseAppliedMigration
implements AppliedMigration {
    protected int installedRank;
    protected MigrationVersion version;
    protected String description;
    protected MigrationType type;
    protected String script;
    protected Integer checksum;
    protected Date installedOn;
    protected String installedBy;
    protected int executionTime;
    protected boolean success;

    public BaseAppliedMigration(int installedRank, MigrationVersion version, String description, String type, String script, Integer checksum, Date installedOn, String installedBy, int executionTime, boolean success) {
        this.installedRank = installedRank;
        this.version = version;
        this.description = description;
        this.type = CoreMigrationType.fromString(type);
        this.script = script;
        this.checksum = checksum;
        this.installedOn = installedOn;
        this.installedBy = installedBy;
        this.executionTime = executionTime;
        this.success = success;
    }

    @Override
    public int getInstalledRank() {
        return this.installedRank;
    }

    @Override
    public MigrationVersion getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public MigrationType getType() {
        return this.type;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public Integer getChecksum() {
        return this.checksum;
    }

    @Override
    public Date getInstalledOn() {
        return this.installedOn;
    }

    @Override
    public String getInstalledBy() {
        return this.installedBy;
    }

    @Override
    public int getExecutionTime() {
        return this.executionTime;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public boolean handlesType(String type) {
        return Arrays.stream(CoreMigrationType.values()).map(Enum::toString).anyMatch(t2 -> t2.equalsIgnoreCase(type));
    }

    @Override
    public AppliedMigration create(int installedRank, MigrationVersion version, String description, String type, String script, Integer checksum, Date installedOn, String installedBy, int executionTime, boolean success) {
        return new BaseAppliedMigration(installedRank, version, description, type, script, checksum, installedOn, installedBy, executionTime, success);
    }

    private boolean isMigrationNotInList(MigrationPattern[] cherryPick, MigrationVersion version, String description) {
        boolean inMigrationList = false;
        for (MigrationPattern migration : cherryPick) {
            if (!migration.matches(version, description)) continue;
            inMigrationList = true;
            break;
        }
        return !inMigrationList;
    }

    @Override
    public MigrationState getState(MigrationInfoContext context, boolean outOfOrder, ResolvedMigration resolvedMigration) {
        if (CoreMigrationType.DELETE == this.getType()) {
            return MigrationState.SUCCESS;
        }
        if (this.getType().isBaseline()) {
            return MigrationState.BASELINE;
        }
        MigrationState missingState = this.getMissingState(context, resolvedMigration);
        if (missingState != null) {
            return missingState;
        }
        if (!this.isSuccess()) {
            return MigrationState.FAILED;
        }
        if (CoreMigrationType.SCHEMA == this.getType()) {
            return MigrationState.SUCCESS;
        }
        MigrationState repeatableState = this.getRepeatableState(context, resolvedMigration);
        if (repeatableState != null) {
            return repeatableState;
        }
        if (outOfOrder) {
            return MigrationState.OUT_OF_ORDER;
        }
        return MigrationState.SUCCESS;
    }

    private MigrationState getRepeatableState(MigrationInfoContext context, ResolvedMigration resolvedMigration) {
        if (this.getVersion() == null) {
            if (this.getInstalledRank() == context.latestRepeatableRuns.get(this.getDescription()).intValue()) {
                if (resolvedMigration != null && resolvedMigration.checksumMatches(this.getChecksum())) {
                    return MigrationState.SUCCESS;
                }
                return MigrationState.OUTDATED;
            }
            return MigrationState.SUPERSEDED;
        }
        return null;
    }

    protected MigrationState getMissingState(MigrationInfoContext context, ResolvedMigration resolvedMigration) {
        if (resolvedMigration == null && this.isRepeatableLatest(context)) {
            if (CoreMigrationType.SCHEMA == this.getType()) {
                return MigrationState.SUCCESS;
            }
            if (this.getVersion() == null || this.getVersion().compareTo(context.lastResolved) < 0) {
                if (this.isSuccess()) {
                    return MigrationState.MISSING_SUCCESS;
                }
                return MigrationState.MISSING_FAILED;
            }
            if (this.isSuccess()) {
                return MigrationState.FUTURE_SUCCESS;
            }
            return MigrationState.FUTURE_FAILED;
        }
        return null;
    }

    private boolean isRepeatableLatest(MigrationInfoContext context) {
        if (this.getVersion() != null) {
            return true;
        }
        Integer latestRepeatableRank = context.latestRepeatableRuns.get(this.getDescription());
        return latestRepeatableRank == null || this.getInstalledRank() == latestRepeatableRank.intValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseAppliedMigration that = (BaseAppliedMigration)o;
        if (this.executionTime != that.executionTime) {
            return false;
        }
        if (this.installedRank != that.installedRank) {
            return false;
        }
        if (this.success != that.success) {
            return false;
        }
        if (this.checksum != null ? !this.checksum.equals(that.checksum) : that.checksum != null) {
            return false;
        }
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (this.installedBy != null ? !this.installedBy.equals(that.installedBy) : that.installedBy != null) {
            return false;
        }
        if (this.installedOn != null ? !this.installedOn.equals(that.installedOn) : that.installedOn != null) {
            return false;
        }
        if (!this.script.equals(that.script)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        int result = this.installedRank;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.script.hashCode();
        result = 31 * result + (this.checksum != null ? this.checksum.hashCode() : 0);
        result = 31 * result + (this.installedOn != null ? this.installedOn.hashCode() : 0);
        result = 31 * result + (this.installedBy != null ? this.installedBy.hashCode() : 0);
        result = 31 * result + this.executionTime;
        result = 31 * result + (this.success ? 1 : 0);
        return result;
    }

    public BaseAppliedMigration(int installedRank, MigrationVersion version, String description, MigrationType type, String script, Integer checksum, Date installedOn, String installedBy, int executionTime, boolean success) {
        this.installedRank = installedRank;
        this.version = version;
        this.description = description;
        this.type = type;
        this.script = script;
        this.checksum = checksum;
        this.installedOn = installedOn;
        this.installedBy = installedBy;
        this.executionTime = executionTime;
        this.success = success;
    }

    public BaseAppliedMigration() {
    }
}

