/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import net.minecraftforge.waifu.util.DynamicSemaphore;

public class SemaphoreGroup {
    private final Map<DynamicSemaphore, Integer> semaphores = new ConcurrentHashMap<DynamicSemaphore, Integer>();
    private final int limit;

    public SemaphoreGroup(int limit) {
        this.limit = limit;
    }

    public Semaphore acquireNew(int amount) {
        DynamicSemaphore sem = new DynamicSemaphore(0);
        this.semaphores.put(sem, amount);
        this.redistribute();
        return sem;
    }

    public void release(Semaphore semaphore) {
        if (semaphore instanceof DynamicSemaphore) {
            DynamicSemaphore dyn = (DynamicSemaphore)semaphore;
            this.semaphores.remove(dyn);
            dyn.setPermits(0);
            this.redistribute();
        }
    }

    private void redistribute() {
        if (this.semaphores.isEmpty()) {
            return;
        }
        int baseline = this.limit / this.semaphores.size();
        int extra = this.limit % this.semaphores.size();
        this.semaphores.keySet().forEach(sem -> sem.setPermits(baseline));
        List sorted2 = this.semaphores.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).toList();
        for (int i = 0; i < extra; ++i) {
            DynamicSemaphore sem2 = (DynamicSemaphore)sorted2.get(i % sorted2.size()).getKey();
            sem2.setPermits(sem2.availablePermits() + 1);
        }
    }
}

