/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.waifu.collect.ModPointer;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.sqlobject.config.KeyColumn;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.sqlobject.transaction.Transactional;

public interface ModIDsDB
extends Transactional<ModIDsDB> {
    @Nullable
    @SqlQuery(value="select id from modids where modId = ? and projectId = ?")
    public Integer getId(String var1, int var2);

    @SqlQuery(value="select id from modids where modId = ?")
    public List<Integer> getIds(String var1);

    default public int get(String modId, int projectId) {
        Integer i = this.getId(modId, projectId);
        if (i != null) {
            return i;
        }
        if (projectId == 0) {
            List<Integer> ids = this.getIds(modId);
            if (!ids.isEmpty()) {
                return ids.get(0);
            }
        } else {
            i = this.getId(modId, 0);
            if (i != null) {
                return i;
            }
        }
        return ((Update)((Update)this.getHandle().createUpdate("insert into modids(modId, projectId) values (?, ?) returning id").bind(0, modId)).bind(1, projectId)).execute((statementSupplier, ctx) -> {
            ResultSet resultSet = ((PreparedStatement)statementSupplier.get()).getResultSet();
            resultSet.next();
            return resultSet.getInt("id");
        });
    }

    @KeyColumn(value="id")
    @UseRowMapper(value=ModPointer.Mapper.class)
    @SqlQuery(value="select * from modids")
    public Map<Integer, ModPointer> getAll();
}

