/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.collect;

import cpw.mods.jarhandling.SecureJar;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.waifu.collect.Collector;
import net.minecraftforge.waifu.collect.CollectorRule;
import net.minecraftforge.waifu.collect.ModPointer;
import net.minecraftforge.waifu.collect.ProgressMonitor;
import net.minecraftforge.waifu.db.InheritanceDB;
import net.minecraftforge.waifu.db.ModIDsDB;
import net.minecraftforge.waifu.db.ProjectsDB;
import net.minecraftforge.waifu.db.RefsDB;
import net.minecraftforge.waifu.util.SemaphoreGroup;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsCollector {
    public static final Logger LOGGER = LoggerFactory.getLogger(StatsCollector.class);
    private static final SemaphoreGroup SEMAPHORES = new SemaphoreGroup(Integer.parseInt(System.getProperty("indexing.max_threads", "50")));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collect(Map<ModPointer, SecureJar> jars, CollectorRule rule, ProjectsDB projects, InheritanceDB inheritance, RefsDB refs, ModIDsDB modIDsDB, Function<ModPointer, Collector> collectorFactory, ProgressMonitor monitor, boolean deleteOldData) throws InterruptedException, ExecutionException {
        jars.entrySet().removeIf(entry -> !rule.shouldCollect(((ModPointer)entry.getKey()).getModId()));
        projects.insert(0, 0);
        HashSet<ModPointer> toKeep = new HashSet<ModPointer>(jars.keySet());
        projects.useTransaction(transactional -> jars.keySet().removeIf(modPointer -> {
            if (modPointer.getProjectId() == 0) {
                return false;
            }
            Integer oldFileId = transactional.getFileId(modPointer.getProjectId());
            return Objects.equals(oldFileId, modPointer.getFileId());
        }));
        ExecutorService executor = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().uncaughtExceptionHandler((t2, e) -> LOGGER.error("Encountered exception collecting information: ", e)).name("stats-collector", 0L).factory());
        monitor.setNumberOfMods(jars.size());
        Semaphore semaphore = SEMAPHORES.acquireNew(jars.size());
        for (Map.Entry<ModPointer, SecureJar> entry2 : jars.entrySet()) {
            executor.submit(() -> {
                semaphore.acquire();
                try {
                    StatsCollector.collect(((ModPointer)entry2.getKey()).getModId(), (SecureJar)entry2.getValue(), rule, (Collector)collectorFactory.apply((ModPointer)entry2.getKey()), monitor);
                }
                finally {
                    semaphore.release();
                }
                return null;
            });
        }
        try {
            executor.close();
        }
        finally {
            SEMAPHORES.release(semaphore);
        }
        if (deleteOldData) {
            Set keptModsId = modIDsDB.inTransaction(transactional -> toKeep.stream().map(pointer -> transactional.get(pointer.getModId(), pointer.getProjectId())).collect(Collectors.toSet()));
            inheritance.delete(inheritance.getAllMods().stream().filter(Predicate.not(keptModsId::contains)).toList());
            refs.delete(refs.getAllMods().stream().filter(Predicate.not(keptModsId::contains)).toList());
        }
    }

    private static void collect(final String modId, SecureJar jar, final CollectorRule rule, final Collector collector, ProgressMonitor monitor) throws IOException {
        monitor.startMod(modId);
        try (Stream<Path> classes = Files.find(jar.getRootPath(), Integer.MAX_VALUE, (path, basicFileAttributes) -> path.getFileName().toString().endsWith(".class"), new FileVisitOption[0]);){
            ClassVisitor visitor = new ClassVisitor(589824){
                final ClassNode owner;
                {
                    super(arg0);
                    this.owner = new ClassNode();
                }

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    this.owner.visit(version, access, name, signature, superName, interfaces);
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    if (!rule.matches(descriptor)) {
                        return null;
                    }
                    final AnnotationNode node = new AnnotationNode(this.api, descriptor);
                    return new AnnotationVisitor(this.api, node){

                        @Override
                        public void visitEnd() {
                            collector.acceptAnnotation(modId, owner, owner, node);
                        }
                    };
                }

                @Override
                public FieldVisitor visitField(final int access, final String name, String descriptor, final String signature, final Object value) {
                    return new FieldVisitor(589824){

                        @Override
                        public AnnotationVisitor visitAnnotation(final String descriptor, boolean visible) {
                            if (!rule.matches(descriptor)) {
                                return null;
                            }
                            final AnnotationNode node = new AnnotationNode(this.api, descriptor);
                            return new AnnotationVisitor(this.api, node){

                                @Override
                                public void visitEnd() {
                                    collector.acceptAnnotation(modId, owner, new FieldNode(access, name, descriptor, signature, value), node);
                                }
                            };
                        }
                    };
                }

                @Override
                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    final MethodNode node = new MethodNode(access, name, descriptor, signature, exceptions);
                    final boolean isInit = name.equals("<init>");
                    this.owner.methods.add(node);
                    return new MethodVisitor(589824, node){

                        @Override
                        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                            if (!rule.matches(descriptor)) {
                                return null;
                            }
                            final AnnotationNode anNode = new AnnotationNode(this.api, descriptor);
                            return new AnnotationVisitor(this.api, anNode){

                                @Override
                                public void visitEnd() {
                                    collector.acceptAnnotation(modId, owner, node, anNode);
                                }
                            };
                        }

                        @Override
                        public void visitEnd() {
                            boolean foundSuper = false;
                            for (AbstractInsnNode insn : node.instructions) {
                                if (isInit && insn.getOpcode() == 183 && !foundSuper && ((MethodInsnNode)insn).owner.equals(owner.superName)) {
                                    foundSuper = true;
                                    continue;
                                }
                                if (!rule.matches(insn)) continue;
                                collector.accept(modId, owner, node, insn);
                            }
                        }
                    };
                }

                @Override
                public void visitEnd() {
                    collector.accept(modId, this.owner);
                    this.owner.methods.clear();
                }
            };
            Iterator cls = classes.iterator();
            while (cls.hasNext()) {
                ClassReader reader = new ClassReader(Files.readAllBytes((Path)cls.next()));
                reader.accept(visitor, 0);
            }
        }
        try {
            collector.commit();
            monitor.completedMod(modId, null);
        }
        catch (Exception exception) {
            monitor.completedMod(modId, exception);
        }
    }
}

