/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.collect;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraftforge.waifu.collect.Collector;
import net.minecraftforge.waifu.collect.ModPointer;
import net.minecraftforge.waifu.db.InheritanceDB;
import net.minecraftforge.waifu.db.InheritanceEntry;
import net.minecraftforge.waifu.db.ModIDsDB;
import net.minecraftforge.waifu.db.ProjectsDB;
import net.minecraftforge.waifu.db.Reference;
import net.minecraftforge.waifu.db.RefsDB;
import net.minecraftforge.waifu.db.Type;
import net.minecraftforge.waifu.util.Remapper;
import org.jdbi.v3.core.Jdbi;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class DefaultDBCollector
implements Collector {
    private final ModPointer mod;
    private final Jdbi jdbi;
    private final Remapper remapper;
    private final boolean collectInheritance;
    private final Map<Reference, AtomicInteger> count = new LinkedHashMap<Reference, AtomicInteger>();
    private final Set<InheritanceEntry> inheritance = new HashSet<InheritanceEntry>();

    public DefaultDBCollector(ModPointer mod, Jdbi jdbi, Remapper remapper, boolean collectInheritance) {
        this.mod = mod;
        this.jdbi = jdbi;
        this.remapper = remapper;
        this.collectInheritance = collectInheritance;
    }

    @Override
    public void accept(String modId, ClassNode clazz) {
        if (this.collectInheritance && !clazz.name.endsWith("package-info") && !clazz.name.endsWith("module-info")) {
            this.inheritance.add(new InheritanceEntry(clazz.name, clazz.superName == null || clazz.superName.equals("java/lang/Object") ? null : clazz.superName, clazz.interfaces, (String[])clazz.methods.stream().map(method -> this.remapper.remapMethod(method.name) + method.desc).toArray(String[]::new)));
        }
    }

    @Override
    public void accept(String modId, ClassNode owner, MethodNode declaring, AbstractInsnNode node) {
        if (node instanceof FieldInsnNode) {
            FieldInsnNode fieldNode = (FieldInsnNode)node;
            this.count.computeIfAbsent(new Reference(fieldNode.owner, this.remapper.remapField(fieldNode.name), Type.FIELD), k -> new AtomicInteger()).incrementAndGet();
        } else if (node instanceof MethodInsnNode) {
            MethodInsnNode methodNode = (MethodInsnNode)node;
            this.count.computeIfAbsent(new Reference(methodNode.owner, this.remapper.remapMethod(methodNode.name), Type.METHOD), k -> new AtomicInteger()).incrementAndGet();
            for (org.objectweb.asm.Type argumentType : org.objectweb.asm.Type.getType(methodNode.desc).getArgumentTypes()) {
                this.count.computeIfAbsent(new Reference(this.getActualType(argumentType), argumentType.getInternalName(), Type.PARAMETER), k -> new AtomicInteger()).incrementAndGet();
            }
        } else if (node instanceof LdcInsnNode) {
            LdcInsnNode ldc = (LdcInsnNode)node;
            org.objectweb.asm.Type type = (org.objectweb.asm.Type)ldc.cst;
            this.count.computeIfAbsent(new Reference(this.getActualType(type), type.getInternalName() + ".class", Type.CLASS), k -> new AtomicInteger()).incrementAndGet();
        }
    }

    @Override
    public void acceptAnnotation(String modId, ClassNode clazz, Object owner, AnnotationNode node) {
        this.count.computeIfAbsent(new Reference(org.objectweb.asm.Type.getType(node.desc).getInternalName(), this.formatAnnotation(owner, node), Type.ANNOTATION), k -> new AtomicInteger()).incrementAndGet();
    }

    @Override
    public void commit() {
        if (this.mod.getProjectId() != 0) {
            this.jdbi.useExtension(ProjectsDB.class, db -> db.insert(this.mod.getProjectId(), this.mod.getFileId()));
        }
        int id = this.jdbi.withExtension(ModIDsDB.class, db -> db.get(this.mod.getModId(), this.mod.getProjectId()));
        this.jdbi.useExtension(RefsDB.class, d -> {
            d.delete(id);
            d.insert(id, this.count.keySet(), this.count.values());
        });
        this.jdbi.useExtension(InheritanceDB.class, db -> {
            db.delete(id);
            db.insert(id, this.inheritance);
        });
    }

    private String getActualType(org.objectweb.asm.Type type) {
        return type.getSort() == 9 ? type.getElementType().getInternalName() : type.getInternalName();
    }

    private String formatAnnotation(Object owner, AnnotationNode annotationNode) {
        String type = owner instanceof ClassNode ? "class" : (owner instanceof MethodNode ? "method" : (owner instanceof FieldNode ? "field" : ""));
        StringBuilder container = new StringBuilder().append('@').append(type).append('(');
        ArrayList<String> values2 = new ArrayList<String>();
        annotationNode.accept(this.annotationVisit(values2, () -> {}));
        return container.append(String.join((CharSequence)", ", values2)).append(')').toString();
    }

    private AnnotationVisitor annotationVisit(final List<String> values2, final Runnable onEnd) {
        return new AnnotationVisitor(589824){

            @Override
            public void visit(String name, Object value) {
                values2.add(name + "=" + 1.valToString(value));
            }

            @Override
            public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                ArrayList vals = new ArrayList();
                return DefaultDBCollector.this.annotationVisit(values2, () -> values2.add(name + "=@(" + String.join((CharSequence)", ", vals) + ")"));
            }

            @Override
            public AnnotationVisitor visitArray(final String name) {
                final ArrayList anns = new ArrayList();
                return new AnnotationVisitor(589824){

                    @Override
                    public void visit(String name2, Object value) {
                        anns.add(1.valToString(value));
                    }

                    @Override
                    public void visitEnd() {
                        values2.add(name + "=[" + String.join((CharSequence)", ", anns) + "]");
                    }
                };
            }

            @Override
            public void visitEnum(String name, String descriptor, String value) {
                values2.add(name + "=" + org.objectweb.asm.Type.getType(descriptor).getInternalName() + "." + value);
            }

            @Override
            public void visitEnd() {
                onEnd.run();
            }

            private static String valToString(Object value) {
                if (value instanceof List) {
                    List list = (List)value;
                    return "[" + list.stream().map(it -> {
                        Object object;
                        if (it instanceof org.objectweb.asm.Type) {
                            org.objectweb.asm.Type tp = (org.objectweb.asm.Type)it;
                            object = tp.getInternalName() + ".class";
                        } else {
                            object = it.toString();
                        }
                        return object;
                    }).collect(Collectors.joining(", ")) + "]";
                }
                if (value instanceof org.objectweb.asm.Type) {
                    org.objectweb.asm.Type tp = (org.objectweb.asm.Type)value;
                    return tp.getInternalName() + ".class";
                }
                return value.toString();
            }
        };
    }
}

