/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu.collect;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public interface CollectorRule {
    public boolean shouldCollect(String var1);

    public boolean matches(AbstractInsnNode var1);

    public boolean matches(String var1);

    public static CollectorRule collectAll() {
        return new CollectorRule(){

            @Override
            public boolean shouldCollect(String modId) {
                return true;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean matches(AbstractInsnNode node) {
                if (node instanceof MethodInsnNode) return true;
                if (node instanceof FieldInsnNode) return true;
                if (!(node instanceof LdcInsnNode)) return false;
                LdcInsnNode ldc = (LdcInsnNode)node;
                if (ldc.cst.getClass() != Type.class) return false;
                return true;
            }

            @Override
            public boolean matches(String annotationDesc) {
                return !annotationDesc.endsWith("kotlin/Metadata;") && !annotationDesc.equals("Lscala/reflect/ScalaSignature;");
            }
        };
    }
}

