/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.jarhandling.SecureJar;
import io.github.matyrobbrt.curseforgeapi.CurseForgeAPI;
import io.github.matyrobbrt.curseforgeapi.request.Response;
import io.github.matyrobbrt.curseforgeapi.schemas.file.File;
import io.github.matyrobbrt.curseforgeapi.util.CurseForgeException;
import io.github.matyrobbrt.curseforgeapi.util.gson.RecordTypeAdapterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraftforge.waifu.BotMain;
import net.minecraftforge.waifu.collect.ModPointer;
import net.minecraftforge.waifu.collect.ProgressMonitor;

public class ModCollector {
    private static final TomlParser PARSER = new TomlParser();
    public static final Path DOWNLOAD_CACHE = BotMain.ROOT.resolve("cfCache");
    private final CurseForgeAPI api;
    private final Set<String> jarJars = new HashSet<String>();
    private final Map<ModPointer, SecureJar> jars = new HashMap<ModPointer, SecureJar>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory(new RecordTypeAdapterFactory()).create();

    public ModCollector(CurseForgeAPI api) {
        this.api = api;
    }

    public Map<ModPointer, SecureJar> getJarsToProcess() {
        return this.jars;
    }

    public void fromModpack(int packId, int fileId, ProgressMonitor monitor) throws CurseForgeException, IOException, URISyntaxException {
        this.fromModpack((File)((Response)this.api.getHelper().getModFile(packId, fileId)).orElseThrow(), monitor);
    }

    public void fromModpack(File packFile, ProgressMonitor monitor) throws CurseForgeException, IOException, URISyntaxException {
        Manifest mf;
        block19: {
            Path modpackFile = this.download(packFile);
            if (modpackFile == null) {
                return;
            }
            try (ZipFile zip2 = new ZipFile(modpackFile.toFile());){
                ZipEntry mfEntry = zip2.getEntry("manifest.json");
                if (mfEntry != null) {
                    try (InputStreamReader reader = new InputStreamReader(zip2.getInputStream(mfEntry));){
                        mf = GSON.fromJson((Reader)reader, Manifest.class);
                        break block19;
                    }
                }
                return;
            }
        }
        List<File> files = ((List)((Response)this.api.getHelper().getFiles(mf.files.stream().mapToInt(FilePointer::fileID).toArray())).orElseThrow()).stream().filter(f -> f.downloadUrl() != null).filter(BotMain.distinct(File::id)).toList();
        monitor.setDownloadTarget(files.size());
        try (ExecutorService executor = Executors.newFixedThreadPool(3, Thread.ofPlatform().name("mod-downloader", 0L).daemon(true).factory());){
            for (File file : files) {
                executor.submit(() -> {
                    try {
                        this.considerFile(file);
                    }
                    finally {
                        monitor.downloadEnded(file);
                    }
                    return null;
                });
            }
        }
    }

    public void considerFile(int projectId, int fileId) throws CurseForgeException, IOException, URISyntaxException {
        this.considerFile((File)((Response)this.api.getHelper().getModFile(projectId, fileId)).orElseThrow());
    }

    public void considerFile(File file) throws IOException, URISyntaxException {
        Path downloaded = this.download(file);
        if (downloaded == null) {
            return;
        }
        this.consider(SecureJar.from(downloaded), new FilePointer(file.modId(), file.id()));
    }

    @Nullable
    public Path download(File file) throws IOException, URISyntaxException {
        if (file.downloadUrl() == null) {
            return null;
        }
        Path path = DOWNLOAD_CACHE.resolve(file.modId() + "/" + file.id() + file.downloadUrl().substring(file.downloadUrl().lastIndexOf(46)));
        if (Files.exists(path, new LinkOption[0]) && Files.size(path) == (long)file.fileLength()) {
            return path;
        }
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        URL url = ModCollector.createURL(file.downloadUrl());
        try (InputStream in = url.openStream();){
            Files.write(path, in.readAllBytes(), new OpenOption[0]);
        }
        return path;
    }

    public void consider(SecureJar jar, @Nullable FilePointer file) throws IOException {
        String modId = ModCollector.getModId(jar);
        if (modId != null) {
            if (file == null) {
                this.jars.put(new ModPointer(modId), jar);
            } else {
                this.jars.put(new ModPointer(modId, file.projectID, file.fileID), jar);
            }
        }
        this.collectJiJFrom(jar);
    }

    public void collectJiJFrom(SecureJar secureJar) throws IOException {
        Path path = secureJar.getPath("META-INF/jarjar/metadata.json", new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            JsonArray array = new Gson().fromJson((Reader)Files.newBufferedReader(path), JsonObject.class).getAsJsonArray("jars");
            for (JsonElement element : array) {
                JsonObject obj = (JsonObject)element;
                JsonObject identifier = obj.getAsJsonObject("identifier");
                String id = identifier.get("group").getAsString() + ":" + identifier.get("artifact").getAsString();
                if (!this.jarJars.add(id)) continue;
                SecureJar jar = SecureJar.from(secureJar.getPath(obj.get("path").getAsString(), new String[0]));
                this.consider(jar, null);
            }
        }
    }

    @Nullable
    public static String getModId(SecureJar jar) throws IOException {
        CommentedConfig config;
        List mods;
        Path path = jar.getPath("META-INF", "mods.toml");
        if (Files.exists(path, new LinkOption[0]) && !(mods = (List)(config = PARSER.parse(Files.newBufferedReader(path))).get("mods")).isEmpty()) {
            return (String)((CommentedConfig)mods.get(0)).get("modId");
        }
        return null;
    }

    private static URL createURL(String url) throws IOException, URISyntaxException {
        int findex = url.indexOf(47, 8);
        return new URI("https", url.substring(8, findex), url.substring(findex), null).toURL();
    }

    record Manifest(List<FilePointer> files) {
    }

    record FilePointer(int projectID, int fileID) {
    }
}

