/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.waifu;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.github.matyrobbrt.curseforgeapi.CurseForgeAPI;
import io.github.matyrobbrt.curseforgeapi.request.Method;
import io.github.matyrobbrt.curseforgeapi.request.Request;
import io.github.matyrobbrt.curseforgeapi.request.Requests;
import io.github.matyrobbrt.curseforgeapi.request.Response;
import io.github.matyrobbrt.curseforgeapi.request.query.ModSearchQuery;
import io.github.matyrobbrt.curseforgeapi.schemas.PaginatedData;
import io.github.matyrobbrt.curseforgeapi.schemas.file.File;
import io.github.matyrobbrt.curseforgeapi.schemas.file.FileIndex;
import io.github.matyrobbrt.curseforgeapi.schemas.mod.Mod;
import io.github.matyrobbrt.curseforgeapi.schemas.mod.ModLoaderType;
import io.github.matyrobbrt.curseforgeapi.util.CurseForgeException;
import io.github.matyrobbrt.curseforgeapi.util.Utils;
import java.awt.Color;
import java.io.BufferedReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.minecraftforge.metabase.MetabaseClient;
import net.minecraftforge.waifu.Database;
import net.minecraftforge.waifu.ModCollector;
import net.minecraftforge.waifu.collect.CollectorRule;
import net.minecraftforge.waifu.collect.DefaultDBCollector;
import net.minecraftforge.waifu.collect.DiscordProgressMonitor;
import net.minecraftforge.waifu.collect.ModPointer;
import net.minecraftforge.waifu.collect.StatsCollector;
import net.minecraftforge.waifu.db.InheritanceDB;
import net.minecraftforge.waifu.db.ModIDsDB;
import net.minecraftforge.waifu.db.ProjectsDB;
import net.minecraftforge.waifu.db.RefsDB;
import net.minecraftforge.waifu.logback.DiscordLogbackAppender;
import net.minecraftforge.waifu.util.MappingUtils;
import net.minecraftforge.waifu.util.Remapper;
import net.minecraftforge.waifu.util.SavedTrackedData;
import org.flywaydb.core.api.output.MigrateResult;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotMain {
    public static final Path ROOT = Path.of(System.getProperty("waifu.rootdir", "/"), new String[0]);
    public static final Logger LOGGER = LoggerFactory.getLogger(BotMain.class);
    private static final int CF_PAGINATION_LIMIT = 10000;
    private static final CurseForgeAPI CF;
    private static final MetabaseClient METABASE;
    private static final SavedTrackedData<Set<Integer>> PACKS;
    private static final SavedTrackedData<Set<String>> GAME_VERSIONS;
    private static final Set<String> CURRENTLY_COLLECTED;
    public static final String VERSION;
    private static JDA jda;

    public static void main(String[] args2) throws Exception {
        ExecutorService rescanner = Executors.newFixedThreadPool(3, r -> {
            Thread thread2 = new Thread(r, "Stats scanner");
            thread2.setDaemon(true);
            thread2.setUncaughtExceptionHandler((t2, e) -> LOGGER.error("Encountered exception on scanner thread: ", e));
            return thread2;
        });
        jda = JDABuilder.createLight(System.getProperty("bot.token"), EnumSet.of(GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MESSAGES)).addEventListeners(gevent -> {
            if (!(gevent instanceof ReadyEvent)) {
                return;
            }
            ReadyEvent event = (ReadyEvent)gevent;
            event.getJDA().updateCommands().addCommands(Commands.slash("modpacks", "Command used to manage collection of stats in modpacks").addSubcommands(new SubcommandData("add", "Collect stats from the given modpack").addOption(OptionType.INTEGER, "modpack", "The ID of the modpack to collect stats from", true)).addSubcommands(new SubcommandData("list", "List all watched modpacks")).addSubcommands(new SubcommandData("remove", "Remove a modpack from stats collection").addOption(OptionType.INTEGER, "modpack", "The ID of the modpack to remove", true).addOption(OptionType.BOOLEAN, "removedb", "Whether to remove the modpack from the database", true)), Commands.slash("gameversion", "Command used to manage collection of stats for specific game versions").addSubcommands(new SubcommandData("add", "Watch a game version").addOption(OptionType.STRING, "version", "The game version to watch", true)).addSubcommands(new SubcommandData("list", "List all watched game versions")).addSubcommands(new SubcommandData("remove", "Un-watch a game version").addOption(OptionType.INTEGER, "version", "The game version to remove", true).addOption(OptionType.BOOLEAN, "removedb", "Whether to remove the game version from the database", true)), Commands.slash("delete-cache", "Deletes the CurseForge downloads cache"), Commands.slash("help", "Information about the bot")).queue();
        }, gevent -> {
            if (!(gevent instanceof SlashCommandInteractionEvent)) {
                return;
            }
            SlashCommandInteractionEvent event = (SlashCommandInteractionEvent)gevent;
            try {
                BotMain.onSlashCommandInteraction(event, rescanner);
            }
            catch (Exception ex) {
                event.getHook().sendMessage("Encountered exception executing command: " + String.valueOf(ex)).queue();
            }
        }).setActivity(Activity.watching("naughty mods")).build().awaitReady();
        DiscordLogbackAppender.setup(jda.getChannelById(MessageChannel.class, System.getProperty("bot.loggingChannel", "0")));
        LOGGER.info("Bot started! Version: {}", (Object)VERSION);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleAtFixedRate(() -> {
            try {
                for (Mod mod : CF.makeRequest(BotMain.getMods((Iterable<Integer>)PACKS.read())).orElseThrow()) {
                    if (!CURRENTLY_COLLECTED.add(String.valueOf(mod.id()))) {
                        return;
                    }
                    rescanner.submit(() -> BotMain.trigger(mod));
                }
            }
            catch (CurseForgeException e) {
                LOGGER.error("Encountered error initiating pack stats collection:", e);
            }
        }, 2L, 60L, TimeUnit.MINUTES);
        scheduler.scheduleAtFixedRate(() -> {
            for (String version : GAME_VERSIONS.read()) {
                if (!CURRENTLY_COLLECTED.add(version)) {
                    return;
                }
                rescanner.submit(() -> {
                    try {
                        BotMain.triggerGameVersion(version);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Encountered exception collecting statistics for game version '{}':", (Object)version, (Object)ex);
                    }
                });
            }
        }, 2L, 1440L, TimeUnit.MINUTES);
    }

    public static Request<List<Mod>> getMods(Iterable<Integer> modIds) {
        JsonObject body = new JsonObject();
        JsonArray array = new JsonArray();
        for (int id : modIds) {
            array.add(id);
        }
        body.add("modIds", array);
        return new Request<List<Mod>>("/v1/mods", Method.POST, body, "data", Requests.Types.MOD_LIST);
    }

    public static void onSlashCommandInteraction(SlashCommandInteractionEvent event, ExecutorService rescanner) throws Exception {
        switch (event.getFullCommandName()) {
            case "modpacks add": {
                Mod pack = CF.makeRequest(Requests.getMod(event.getOption("modpack", 0, OptionMapping::getAsInt))).orElse(null);
                if (pack == null || pack.gameId() != 432 || pack.classId() != 4471) {
                    event.reply("Unknown modpack!").setEphemeral(true).queue();
                    return;
                }
                event.reply("Watching modpack. Started indexing, please wait...").queue();
                CURRENTLY_COLLECTED.add(String.valueOf(pack.id()));
                PACKS.useHandle(v -> v.add(pack.id()));
                rescanner.submit(() -> {
                    BotMain.trigger(pack);
                    event.getHook().editOriginal("Finished initial indexing.").queue();
                });
                break;
            }
            case "modpacks list": {
                PACKS.useHandle(packs -> {
                    if (packs.isEmpty()) {
                        event.reply("No packs watched!").queue();
                    } else {
                        event.reply(packs.stream().map(String::valueOf).collect(Collectors.joining(", "))).queue();
                    }
                });
                break;
            }
            case "modpacks remove": {
                Set<Integer> packs2 = PACKS.read();
                int packId = event.getOption("modpack", 0, OptionMapping::getAsInt);
                if (!packs2.contains(packId)) {
                    event.reply("Unknown pack!").setEphemeral(true).queue();
                    return;
                }
                packs2.remove(packId);
                PACKS.write();
                if (event.getOption("removedb", false, OptionMapping::getAsBoolean).booleanValue()) {
                    try (Connection con = Database.initiateDBConnection();
                         Statement stmt = con.createStatement();){
                        stmt.execute("drop schema if exists pack_" + packId + " cascade;");
                    }
                }
                event.reply("Pack removed!").queue();
                break;
            }
            case "gameversion add": {
                String gameVersion = event.getOption("version", "", OptionMapping::getAsString);
                if (((Response)CF.getHelper().getGameVersions(432)).orElse(List.of()).stream().flatMap(g2 -> g2.versions().stream()).noneMatch(s2 -> s2.equals(gameVersion))) {
                    event.reply("Unknown game version!").setEphemeral(true).queue();
                    return;
                }
                event.reply("Watching game version. Started indexing, please wait...").queue();
                CURRENTLY_COLLECTED.add(gameVersion);
                GAME_VERSIONS.useHandle(v -> v.add(gameVersion));
                rescanner.submit(() -> {
                    try {
                        BotMain.triggerGameVersion(gameVersion);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Encountered exception indexing game version '{}': ", (Object)gameVersion, (Object)ex);
                    }
                });
                break;
            }
            case "gameversion list": {
                GAME_VERSIONS.useHandle(versions -> {
                    if (versions.isEmpty()) {
                        event.reply("No game versions watched!").queue();
                    } else {
                        event.reply(versions.stream().map(String::valueOf).collect(Collectors.joining(", "))).queue();
                    }
                });
                break;
            }
            case "gameversion remove": {
                Set<String> versions2 = GAME_VERSIONS.read();
                String versionID = event.getOption("version", "", OptionMapping::getAsString);
                if (!versions2.contains(versionID)) {
                    event.reply("Unknown game version!").setEphemeral(true).queue();
                    return;
                }
                versions2.remove(versionID);
                GAME_VERSIONS.write();
                if (event.getOption("removedb", false, OptionMapping::getAsBoolean).booleanValue()) {
                    try (Connection con = Database.initiateDBConnection();
                         Statement stmt = con.createStatement();){
                        stmt.execute("drop schema if exists " + BotMain.computeVersionSchema(versionID) + " cascade;");
                    }
                }
                event.reply("Game version removed!").queue();
                break;
            }
            case "delete-cache": {
                if (!CURRENTLY_COLLECTED.isEmpty()) {
                    event.reply("Cannot delete CurseForge cache while indexing is in progress!").setEphemeral(true).queue();
                    break;
                }
                event.reply("Deleting caches...").queue();
                try (Stream<Path> toDelete = Files.find(ModCollector.DOWNLOAD_CACHE, Integer.MAX_VALUE, (path, basicFileAttributes) -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".jar") || path.toString().endsWith(".zip"), new FileVisitOption[0]);){
                    Iterator itr = toDelete.iterator();
                    while (itr.hasNext()) {
                        Files.delete((Path)itr.next());
                    }
                }
                event.getHook().editOriginal("Deleted caches!").queue();
                break;
            }
            case "help": {
                event.replyEmbeds(new EmbedBuilder().setTitle("WhatAmIForgingUp", "https://github.com/MinecraftForge/WhatAmIForgingUp").setDescription("A bot used to index Minecraft mods on CurseForge.").addField("Version", VERSION, false).setColor(Color.GREEN).build(), new MessageEmbed[0]).queue();
            }
        }
    }

    private static void trigger(Mod pack) {
        try {
            String schemaName = "pack_" + pack.id();
            Map.Entry<MigrateResult, Jdbi> connection = Database.createDatabaseConnection(schemaName);
            if (connection.getKey().initialSchemaVersion == null) {
                Database.updateMetabase(METABASE, schemaName);
            }
            Jdbi jdbi = connection.getValue();
            ProjectsDB projects = jdbi.onDemand(ProjectsDB.class);
            ModCollector collector = new ModCollector(CF);
            File mainFile = (File)((Response)CF.getHelper().getModFile(pack.id(), pack.mainFileId())).orElseThrow();
            if (Objects.equals(projects.getFileId(pack.id()), mainFile.id())) {
                LOGGER.trace("Pack {} is up-to-date.", (Object)pack.id());
                return;
            }
            Message logging = (Message)jda.getChannelById(MessageChannel.class, System.getProperty("bot.loggingChannel")).sendMessage("Status of collection of statistics of **" + pack.name() + "**, file ID: " + mainFile.id()).complete();
            LOGGER.info("Found new file ({}) for pack {}: started stats collection.", (Object)mainFile.id(), (Object)pack.id());
            DiscordProgressMonitor progressMonitor = new DiscordProgressMonitor(logging, (id, ex) -> LOGGER.error("Collection for mod '{}' in pack {} failed:", id, pack.id(), ex));
            progressMonitor.markCollection(-1);
            collector.fromModpack(mainFile, progressMonitor);
            Remapper remapper = Remapper.fromMappings(MappingUtils.srgToMoj(mainFile.sortableGameVersions().stream().filter(g2 -> !g2.gameVersion().isBlank()).max(Comparator.comparing(g2 -> Instant.parse(g2.gameVersionReleaseDate()))).orElseThrow().gameVersion()));
            StatsCollector.collect(collector.getJarsToProcess(), CollectorRule.collectAll(), projects, jdbi.onDemand(InheritanceDB.class), jdbi.onDemand(RefsDB.class), jdbi.onDemand(ModIDsDB.class), mid -> new DefaultDBCollector((ModPointer)mid, jdbi, remapper, true), progressMonitor, true);
            LOGGER.info("Finished stats collection of pack {}", (Object)pack.id());
            CURRENTLY_COLLECTED.remove(String.valueOf(pack.id()));
            projects.insert(pack.id(), mainFile.id());
        }
        catch (Exception ex2) {
            LOGGER.error("Encountered exception collecting stats of pack: ", ex2);
        }
    }

    private static void triggerGameVersion(String gameVersion) throws Exception {
        PaginatedData response;
        String schemaName = BotMain.computeVersionSchema(gameVersion);
        Map.Entry<MigrateResult, Jdbi> connection = Database.createDatabaseConnection(schemaName);
        if (connection.getKey().initialSchemaVersion == null) {
            Database.updateMetabase(METABASE, schemaName);
        }
        Jdbi jdbi = connection.getValue();
        ProjectsDB projects = jdbi.onDemand(ProjectsDB.class);
        Set<Integer> fileIds = projects.getFileIDs();
        ArrayList<FileIndex> newMods = new ArrayList<FileIndex>();
        int idx = 0;
        int maxItems = 10000;
        block5: while (idx < maxItems && (response = (PaginatedData)((Response)CF.getHelper().searchModsPaginated(ModSearchQuery.of(432).gameVersion(gameVersion).classId(6).sortField(ModSearchQuery.SortField.LAST_UPDATED).sortOrder(ModSearchQuery.SortOrder.ASCENDENT).modLoaderType(ModLoaderType.FORGE).pageSize(50).index(idx))).orElse(null)) != null) {
            idx = response.pagination().index() + 50;
            maxItems = Math.min(response.pagination().totalCount(), 10000);
            for (Mod mod : (List)response.data()) {
                FileIndex matching = mod.latestFilesIndexes().stream().filter(f -> f.gameVersion().equals(gameVersion) && f.modLoader() != null && f.modLoaderType() == ModLoaderType.FORGE).limit(1L).findFirst().orElse(null);
                if (matching == null) continue;
                if (fileIds.contains(matching.fileId())) break block5;
                newMods.add(matching);
            }
        }
        if (newMods.isEmpty()) {
            LOGGER.info("Found no new mods to collect stats on for game version {}.", (Object)gameVersion);
            return;
        }
        Message logging = (Message)jda.getChannelById(MessageChannel.class, System.getProperty("bot.loggingChannel")).sendMessage("Status of collection of statistics for game version '" + gameVersion + "'").complete();
        LOGGER.info("Started stats collection for game version '{}'. Found {} mods to scan.", (Object)gameVersion, (Object)newMods.size());
        DiscordProgressMonitor progressMonitor = new DiscordProgressMonitor(logging, (id, ex) -> LOGGER.error("Collection for mod '{}' in game version '{}' failed:", id, gameVersion, ex));
        progressMonitor.markCollection(newMods.size());
        ModCollector collector = new ModCollector(CF);
        List<File> toDownload = ((List)((Response)CF.getHelper().getFiles(newMods.stream().mapToInt(FileIndex::fileId).toArray())).orElseThrow()).stream().filter(f -> f.downloadUrl() != null).filter(BotMain.distinct(File::id)).toList();
        progressMonitor.setDownloadTarget(toDownload.size());
        try (ExecutorService executor = Executors.newFixedThreadPool(3, Thread.ofPlatform().name("mod-downloader", 0L).daemon(true).factory());){
            for (File file : toDownload) {
                executor.submit(() -> {
                    try {
                        collector.considerFile(file);
                    }
                    finally {
                        progressMonitor.downloadEnded(file);
                    }
                    return null;
                });
            }
        }
        Remapper remapper = Remapper.fromMappings(MappingUtils.srgToMoj(gameVersion));
        StatsCollector.collect(collector.getJarsToProcess(), CollectorRule.collectAll(), projects, jdbi.onDemand(InheritanceDB.class), jdbi.onDemand(RefsDB.class), jdbi.onDemand(ModIDsDB.class), mid -> new DefaultDBCollector((ModPointer)mid, jdbi, remapper, true), progressMonitor, false);
        LOGGER.info("Finished stats collection for game version '{}'", (Object)gameVersion);
        CURRENTLY_COLLECTED.remove(gameVersion);
    }

    private static String computeVersionSchema(String version) {
        return "gv_" + version.replace('.', '_').replace('-', '_');
    }

    public static <T, Z> Predicate<T> distinct(Function<T, Z> extractor) {
        HashSet values2 = new HashSet();
        return t2 -> values2.add(extractor.apply(t2));
    }

    static {
        Path propsPath = Path.of(System.getProperty("waifu.propsFile", "bot.properties"), new String[0]);
        if (Files.exists(propsPath, new LinkOption[0])) {
            Properties props = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(propsPath);){
                props.load(reader);
            }
            catch (Exception ex) {
                LOGGER.error("Could not read properties:", ex);
            }
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(o, o2) -> System.setProperty(o.toString(), o2.toString())));
        }
        CF = Utils.rethrowSupplier(() -> CurseForgeAPI.builder().apiKey(System.getProperty("curseforge.token")).build()).get();
        METABASE = new MetabaseClient(System.getProperty("metabase.url"), System.getProperty("metabase.user"), System.getProperty("metabase.password"));
        PACKS = new SavedTrackedData<Set>(new TypeToken<Set<Integer>>(){}, HashSet::new, ROOT.resolve("data/modpacks.json"));
        GAME_VERSIONS = new SavedTrackedData<Set>(new TypeToken<Set<String>>(){}, HashSet::new, ROOT.resolve("data/game_versions.json"));
        CURRENTLY_COLLECTED = new CopyOnWriteArraySet<String>();
        VERSION = Objects.requireNonNullElse(BotMain.class.getPackage().getImplementationVersion(), "UNKNOWN");
    }
}

