/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.metabase.types;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraftforge.metabase.MetabaseClient;
import net.minecraftforge.metabase.RequestParameters;
import net.minecraftforge.metabase.Route;
import net.minecraftforge.metabase.internal.MetabaseType;
import net.minecraftforge.metabase.params.TableUpdateParameters;
import net.minecraftforge.metabase.types.Field;

@MetabaseType
public record Table(MetabaseClient client, int id, @SerializedName(value="db_id") int dbId, boolean active, String schema, String name, String description, List<Field> fields) {
    private static final Route<Table> UPDATE_TABLE = Route.update("/table/:id", Table.class);
    private static final Route<List<Table>> UPDATE_TABLE_GENERAL = Route.put("/table", requestParameters -> (JsonElement)requestParameters.getIndex(0), Route.decodeType(new TypeToken<List<Table>>(){}));

    public CompletableFuture<Table> update(UnaryOperator<TableUpdateParameters> parameters) {
        return this.client.sendRequest(UPDATE_TABLE.compile(RequestParameters.of("id", this.id, "params", parameters.apply(new TableUpdateParameters()))));
    }

    public CompletableFuture<Table> setHidden(boolean hidden) {
        JsonObject request = new JsonObject();
        request.addProperty("visibility_type", hidden ? "hidden" : null);
        JsonArray ids = new JsonArray();
        ids.add(this.id());
        request.add("ids", ids);
        return this.client.sendRequest(UPDATE_TABLE_GENERAL.compile(RequestParameters.of(request))).thenApply(l -> (Table)l.get(0));
    }
}

