/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.metabase.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraftforge.metabase.MetabaseClient;
import net.minecraftforge.metabase.RequestParameters;
import net.minecraftforge.metabase.Route;
import net.minecraftforge.metabase.internal.MetabaseType;
import net.minecraftforge.metabase.params.FieldUpdateParameters;

@MetabaseType
public record Field(MetabaseClient client, JsonObject _json, int id, String name, @SerializedName(value="display_name") String displayName) {
    private static final Route<Field> UPDATE_FIELD = Route.update("/field/:id", Field.class);
    private static final Route<Void> UPDATE_DIMENSION = Route.post("/field/:id/dimension", requestParameters -> (JsonElement)requestParameters.getIndex(0), Route.VOID);
    private static final Route<Void> DELETE_DIMENSION = Route.delete("/field/:id/dimension");

    public CompletableFuture<Field> update(UnaryOperator<FieldUpdateParameters> parameters) {
        return this.client.sendRequest(UPDATE_FIELD.compile(RequestParameters.of("id", this.id, "params", parameters.apply(new FieldUpdateParameters(this)))));
    }

    public CompletableFuture<Void> setDimension(int targetField, String targetFieldName) {
        JsonObject structure = new JsonObject();
        structure.addProperty("human_readable_field_id", targetField);
        structure.addProperty("name", targetFieldName);
        structure.addProperty("type", "external");
        return this.client.sendRequest(UPDATE_DIMENSION, structure, "id", this.id());
    }

    public CompletableFuture<Void> deleteDimension() {
        return this.client.sendRequest(DELETE_DIMENSION, "id", this.id());
    }
}

