/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.metabase.internal;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.metabase.MetabaseClient;
import net.minecraftforge.metabase.internal.MetabaseType;

public record MetabaseTypeAdapterFactory(MetabaseClient client) implements TypeAdapterFactory
{
    private static final Map<Class<?>, Object> DEFAULTS = new HashMap();

    @Override
    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
        final Class<T> clazz = type.getRawType();
        if (!clazz.isRecord() && clazz.getAnnotation(MetabaseType.class) == null) {
            return null;
        }
        final TypeAdapter<T> delegate = gson.getDelegateAdapter(this, type);
        final RecordComponent[] recordComponents = clazz.getRecordComponents();
        final HashMap typeMap = new HashMap();
        for (RecordComponent recordComponent : recordComponents) {
            typeMap.put(this.getName(recordComponent), TypeToken.get(recordComponent.getGenericType()));
        }
        final boolean needsFull = typeMap.containsKey("_json");
        return new TypeAdapter<T>(){

            @Override
            public void write(JsonWriter out, T value) throws IOException {
                delegate.write(out, value);
            }

            @Override
            public T read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                HashMap<String, Object> argsMap = new HashMap<String, Object>();
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (typeMap.containsKey(name)) {
                        argsMap.put(name, gson.getAdapter((TypeToken)typeMap.get(name)).read(reader));
                        continue;
                    }
                    reader.skipValue();
                }
                if (needsFull) {
                    argsMap.put("_json", gson.toJsonTree(argsMap));
                }
                argsMap.put("client", MetabaseTypeAdapterFactory.this.client);
                reader.endObject();
                Class[] argTypes = new Class[recordComponents.length];
                Object[] args2 = new Object[recordComponents.length];
                for (int i = 0; i < recordComponents.length; ++i) {
                    RecordComponent recComp = recordComponents[i];
                    argTypes[i] = recComp.getType();
                    String name = MetabaseTypeAdapterFactory.this.getName(recComp);
                    Object value = argsMap.get(name);
                    TypeToken type = (TypeToken)typeMap.get(name);
                    if (value == null && type != null) {
                        value = DEFAULTS.get(type.getRawType());
                    }
                    args2[i] = value;
                }
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(argTypes);
                    constructor.setAccessible(true);
                    return constructor.newInstance(args2);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private String getName(RecordComponent component) {
        SerializedName ann = component.getAnnotation(SerializedName.class);
        if (ann == null) {
            return component.getName();
        }
        return ann.value();
    }

    static {
        DEFAULTS.put(Byte.TYPE, (byte)0);
        DEFAULTS.put(Integer.TYPE, 0);
        DEFAULTS.put(Long.TYPE, 0L);
        DEFAULTS.put(Short.TYPE, (short)0);
        DEFAULTS.put(Double.TYPE, 0.0);
        DEFAULTS.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULTS.put(Character.TYPE, Character.valueOf('\u0000'));
        DEFAULTS.put(Boolean.TYPE, false);
        DEFAULTS.put(List.class, List.of());
    }
}

