/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.metabase.internal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;

public class HttpClientUtils {
    private static final Gson GSON = new Gson();

    public static HttpRequest.BodyPublisher jsonPublisher(Map<String, ?> parameters) {
        return HttpRequest.BodyPublishers.ofString(GSON.toJson(parameters));
    }

    public static HttpRequest.BodyPublisher jsonPublisher(JsonElement element) {
        return HttpRequest.BodyPublishers.ofString(element.toString());
    }

    public static HttpResponse.BodyHandler<JsonElement> ofJson() {
        HttpResponse.BodySubscriber<InputStream> upstream = HttpResponse.BodySubscribers.ofInputStream();
        return responseInfo -> HttpResponse.BodySubscribers.mapping(upstream, is -> {
            JsonElement jsonElement;
            InputStreamReader reader = new InputStreamReader((InputStream)is);
            try {
                jsonElement = GSON.fromJson((Reader)reader, JsonElement.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ((Reader)reader).close();
            return jsonElement;
        });
    }
}

