/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.metabase;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import net.minecraftforge.metabase.MetabaseClient;
import net.minecraftforge.metabase.Request;
import net.minecraftforge.metabase.RequestMethod;
import net.minecraftforge.metabase.RequestParameters;
import net.minecraftforge.metabase.params.UpdateParameters;

public record Route<T>(String path, RequestMethod method, Function<RequestParameters, JsonElement> bodyGetter, BiFunction<MetabaseClient, JsonElement, T> decoder) {
    private static final Function<RequestParameters, JsonElement> NONE = r -> null;
    public static final BiFunction<MetabaseClient, JsonElement, Void> VOID = (client, element) -> null;

    public static <T> Route<T> post(String path, Function<RequestParameters, JsonElement> body, BiFunction<MetabaseClient, JsonElement, T> decoder) {
        return new Route<T>(path, RequestMethod.POST, body, decoder);
    }

    public static <T> Route<T> put(String path, Function<RequestParameters, JsonElement> body, BiFunction<MetabaseClient, JsonElement, T> decoder) {
        return new Route<T>(path, RequestMethod.PUT, body, decoder);
    }

    public static <T> Route<T> getEntityByID(String entityType, Class<T> type) {
        return new Route<Object>("/" + entityType + "/:id", RequestMethod.GET, NONE, (client, element) -> client.gson.fromJson((JsonElement)element, type));
    }

    public static <T> Route<List<T>> getEntities(String entityType, Class<T> type) {
        return new Route<List<T>>("/" + entityType + "/", RequestMethod.GET, NONE, (client, element) -> {
            JsonArray array = element.isJsonObject() ? element.getAsJsonObject().getAsJsonArray("data") : element.getAsJsonArray();
            return StreamSupport.stream(array.spliterator(), false).map(el -> client.gson.fromJson((JsonElement)el, type)).toList();
        });
    }

    public static <T> Route<T> update(String path, Class<T> type) {
        return new Route<Object>(path, RequestMethod.PUT, requestParameters -> ((UpdateParameters)requestParameters.get("params")).compile(), (client, element) -> client.gson.fromJson((JsonElement)element, type));
    }

    public static Route<Void> delete(String path) {
        return new Route<Void>(path, RequestMethod.DELETE, NONE, VOID);
    }

    public Request<T> compile(RequestParameters parameters) {
        return new Request<T>(parameters.compilePath(this.path), this.method, this.decoder, this.bodyGetter.apply(parameters));
    }

    public static <T> BiFunction<MetabaseClient, JsonElement, T> decodeType(TypeToken<T> type) {
        Type actualType = type.getType();
        return (client, element) -> client.gson.fromJson((JsonElement)element, actualType);
    }
}

