/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.metabase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraftforge.metabase.params.QueryParameters;

public class RequestParameters {
    public static final Pattern PATH_PATTERN = Pattern.compile(":([a-z0-9]+)");
    private final List<Object> indexedValues = new ArrayList<Object>();
    private final Map<String, Object> values = new HashMap<String, Object>();

    private RequestParameters(Object[] values2) {
        Object o;
        int i;
        for (i = 0; i < values2.length && !((o = values2[i]) instanceof String); ++i) {
            this.indexedValues.add(o);
        }
        while (i < values2.length) {
            String key = values2[i].toString();
            if (i + 1 >= values2.length) {
                throw new IllegalArgumentException("RequestParameters with odd number of named arguments!");
            }
            this.values.put(key, values2[i + 1]);
            i += 2;
        }
    }

    public static RequestParameters of(Object ... values2) {
        return new RequestParameters(values2);
    }

    public String compilePath(String path) {
        String newPath = PATH_PATTERN.matcher(path).replaceAll(result -> {
            String group = result.group(1);
            try {
                int num = Integer.parseInt(group);
                if (num >= this.indexedValues.size()) {
                    return this.get(group).toString();
                }
                return this.getIndex(num).toString();
            }
            catch (Exception ex) {
                return this.get(group).toString();
            }
        });
        return this.indexedValues.stream().filter(it -> it instanceof QueryParameters).findFirst().map(it -> newPath + "?" + ((QueryParameters)it).compile().entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining("&"))).orElse(newPath);
    }

    public Object get(String key) {
        return this.values.get(key);
    }

    public Object getIndex(int index) {
        return this.indexedValues.get(index);
    }
}

