/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.metabase;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraftforge.metabase.Request;
import net.minecraftforge.metabase.RequestParameters;
import net.minecraftforge.metabase.Route;
import net.minecraftforge.metabase.params.DatabaseQueryParameters;
import net.minecraftforge.metabase.params.DatabasesQueryParameters;
import net.minecraftforge.metabase.types.Database;
import net.minecraftforge.metabase.types.Table;

public interface MetabaseClientRequests {
    public static final Route<Table> GET_TABLE = Route.getEntityByID("table", Table.class);
    public static final Route<List<Table>> GET_TABLES = Route.getEntities("table", Table.class);
    public static final Route<Database> GET_DATABASE = Route.getEntityByID("database", Database.class);
    public static final Route<List<Database>> GET_DATABASES = Route.getEntities("database", Database.class);

    default public CompletableFuture<Table> getTable(int id) {
        return this.sendRequest(GET_TABLE, "id", id);
    }

    default public CompletableFuture<List<Table>> getTables() {
        return this.sendRequest(GET_TABLES, new Object[0]);
    }

    default public CompletableFuture<Database> getDatabase(int id, UnaryOperator<DatabaseQueryParameters> parameters) {
        return this.sendRequest(GET_DATABASE, parameters.apply(new DatabaseQueryParameters()), "id", id);
    }

    default public CompletableFuture<List<Database>> getDatabases(UnaryOperator<DatabasesQueryParameters> parameters) {
        return this.sendRequest(GET_DATABASES, parameters.apply(new DatabasesQueryParameters()));
    }

    public <T> CompletableFuture<T> sendRequest(Request<T> var1);

    default public <T> CompletableFuture<T> sendRequest(Route<T> route, Object ... parameters) {
        return this.sendRequest(route.compile(RequestParameters.of(parameters)));
    }
}

