/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.metabase;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraftforge.metabase.MetabaseClientRequests;
import net.minecraftforge.metabase.Request;
import net.minecraftforge.metabase.StatusCodeException;
import net.minecraftforge.metabase.internal.HttpClientUtils;
import net.minecraftforge.metabase.internal.MetabaseTypeAdapterFactory;

public final class MetabaseClient
implements MetabaseClientRequests {
    public static final long MAX_TOKEN_LIFE = Duration.ofDays(1L).toMillis();
    private final URI baseURL;
    private final String username;
    private final String password;
    public final Gson gson;
    private final HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(20L)).followRedirects(HttpClient.Redirect.ALWAYS).build();
    private String cachedToken;
    private long tokenExpiration;

    public MetabaseClient(String baseURL, String username, String password) {
        this.baseURL = URI.create(baseURL);
        this.username = username;
        this.password = password;
        this.gson = new GsonBuilder().registerTypeAdapterFactory(new MetabaseTypeAdapterFactory(this)).setExclusionStrategies(new ExclusionStrategy(){

            @Override
            public boolean shouldSkipField(FieldAttributes f) {
                return false;
            }

            @Override
            public boolean shouldSkipClass(Class<?> clazz) {
                return clazz == MetabaseClient.class;
            }
        }).create();
    }

    @Override
    public <T> CompletableFuture<T> sendRequest(Request<T> request) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(this.baseURL.resolve(request.path().startsWith("/") ? "/api" + request.path() : "/api/" + request.path())).header("X-Metabase-Session", this.getToken()).header("Accept", "application/json");
        switch (request.method()) {
            case GET: {
                builder.GET();
                break;
            }
            case DELETE: {
                builder.DELETE();
                break;
            }
            case POST: {
                builder.POST(HttpClientUtils.jsonPublisher(request.body())).header("Content-Type", "application/json");
                break;
            }
            case PUT: {
                builder.PUT(HttpClientUtils.jsonPublisher(request.body())).header("Content-Type", "application/json");
            }
        }
        return this.client.sendAsync(builder.build(), HttpClientUtils.ofJson()).thenApply(response -> {
            if (response.statusCode() == 204) {
                return null;
            }
            if (response.statusCode() != 200) {
                throw new StatusCodeException(response.statusCode(), request.path());
            }
            return request.mapper().apply(this, (JsonElement)response.body());
        });
    }

    private String getToken() {
        if (this.cachedToken != null && this.tokenExpiration > System.currentTimeMillis()) {
            return this.cachedToken;
        }
        try {
            HttpRequest request = HttpRequest.newBuilder(this.baseURL.resolve("/api/session")).POST(HttpClientUtils.jsonPublisher(Map.of("username", this.username, "password", this.password))).header("Content-Type", "application/json").build();
            HttpResponse<JsonElement> response = this.client.send(request, HttpClientUtils.ofJson());
            if (response.statusCode() != 200) {
                throw new StatusCodeException(response.statusCode(), "/session");
            }
            this.tokenExpiration = System.currentTimeMillis() + MAX_TOKEN_LIFE;
            this.cachedToken = response.body().getAsJsonObject().get("id").getAsString();
            return this.cachedToken;
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return "Metabase@" + this.baseURL;
    }
}

