/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.util.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.HashMap;
import java.util.Map;

public class RecordTypeAdapterFactory
implements TypeAdapterFactory {
    private static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS = new HashMap();

    @Override
    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
        final Class<T> clazz = type.getRawType();
        if (!clazz.isRecord()) {
            return null;
        }
        final TypeAdapter<T> delegate = gson.getDelegateAdapter(this, type);
        return new TypeAdapter<T>(){

            @Override
            public void write(JsonWriter out, T value) throws IOException {
                delegate.write(out, value);
            }

            @Override
            public T read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                RecordComponent[] recordComponents = clazz.getRecordComponents();
                HashMap typeMap = new HashMap();
                for (int i = 0; i < recordComponents.length; ++i) {
                    typeMap.put(recordComponents[i].getName(), TypeToken.get(recordComponents[i].getGenericType()));
                }
                HashMap argsMap = new HashMap();
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (typeMap.containsKey(name)) {
                        argsMap.put(name, gson.getAdapter((TypeToken)typeMap.get(name)).read(reader));
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                Class[] argTypes = new Class[recordComponents.length];
                Object[] args2 = new Object[recordComponents.length];
                for (int i = 0; i < recordComponents.length; ++i) {
                    argTypes[i] = recordComponents[i].getType();
                    String name = recordComponents[i].getName();
                    Object value = argsMap.get(name);
                    TypeToken type = (TypeToken)typeMap.get(name);
                    if (value == null && type != null && type.getRawType().isPrimitive()) {
                        value = PRIMITIVE_DEFAULTS.get(type.getRawType());
                    }
                    args2[i] = value;
                }
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(argTypes);
                    constructor.setAccessible(true);
                    return constructor.newInstance(args2);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static {
        PRIMITIVE_DEFAULTS.put(Byte.TYPE, (byte)0);
        PRIMITIVE_DEFAULTS.put(Integer.TYPE, 0);
        PRIMITIVE_DEFAULTS.put(Long.TYPE, 0L);
        PRIMITIVE_DEFAULTS.put(Short.TYPE, (short)0);
        PRIMITIVE_DEFAULTS.put(Double.TYPE, 0.0);
        PRIMITIVE_DEFAULTS.put(Float.TYPE, Float.valueOf(0.0f));
        PRIMITIVE_DEFAULTS.put(Character.TYPE, Character.valueOf('\u0000'));
        PRIMITIVE_DEFAULTS.put(Boolean.TYPE, false);
    }
}

