/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.github.matyrobbrt.curseforgeapi.annotation.Nullable;
import io.github.matyrobbrt.curseforgeapi.util.ExceptionConsumer;
import io.github.matyrobbrt.curseforgeapi.util.ExceptionFunction;
import io.github.matyrobbrt.curseforgeapi.util.ExceptionRunnable;
import io.github.matyrobbrt.curseforgeapi.util.ExceptionSupplier;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Utils {
    public static <T> T makeWithSupplier(Supplier<T> supplier) {
        return supplier.get();
    }

    public static List<JsonElement> jsonArrayToList(JsonArray array) {
        ArrayList<JsonElement> list = new ArrayList<JsonElement>();
        array.forEach(list::add);
        return list;
    }

    public static <E extends Throwable> void sneakyThrow(Throwable ex) throws E {
        throw ex;
    }

    public static <T> Supplier<T> rethrowSupplier(ExceptionSupplier<T, ?> supplier) {
        return supplier::getNoException;
    }

    public static <T, R> Function<T, R> rethrowFunction(ExceptionFunction<T, R, ?> function) {
        return function::applyNoException;
    }

    public static <T> Consumer<T> rethrowConsumer(ExceptionConsumer<T, ?> consumer) {
        return consumer;
    }

    public static Runnable rethrowRunnable(ExceptionRunnable<?> runnable2) {
        return runnable2;
    }

    public static String encodeURL(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }
}

