/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.util;

import io.github.matyrobbrt.curseforgeapi.annotation.Nonnull;
import io.github.matyrobbrt.curseforgeapi.annotation.Nullable;
import io.github.matyrobbrt.curseforgeapi.request.Response;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public record Pair<F, S>(F first, S second) {
    private static final Map<Class<?>, Predicate<?>> IS_PRESENT_PREDICATES = new HashMap();

    public static <T> void registerIsPresentPredicate(Class<T> clazz, Predicate<T> predicate) {
        IS_PRESENT_PREDICATES.put(clazz, Pair.getIsPresentPredicate(clazz).and(predicate));
    }

    @Nonnull
    public static <T> Predicate<T> getIsPresentPredicate(Class<T> clazz) {
        return IS_PRESENT_PREDICATES.computeIfAbsent(clazz, k -> v -> true);
    }

    public static <F, S> Pair<F, S> of(@Nullable F first, @Nullable S second) {
        return new Pair<F, S>(first, second);
    }

    public static <F, S> Pair<F, S> empty() {
        return Pair.of(null, null);
    }

    public static <F, S> Optional<Pair<F, S>> mapResponses(Pair<Response<F>, Response<S>> pair) {
        return pair.toOptional().map((? super T p) -> p.mapBoth(Response::get, Response::get));
    }

    public Pair<F, S> accept(BiConsumer<? super F, ? super S> consumer) {
        consumer.accept(this.first(), this.second());
        return this;
    }

    public Pair<F, S> acceptFirst(Consumer<? super F> consumer) {
        consumer.accept(this.first());
        return this;
    }

    public Pair<F, S> acceptSecond(Consumer<? super S> consumer) {
        consumer.accept(this.second());
        return this;
    }

    public <T> T map(BiFunction<? super F, ? super S, ? extends T> mapper) {
        return mapper.apply(this.first(), this.second());
    }

    public <NEW_FIRST, NEW_SECOND> Pair<NEW_FIRST, NEW_SECOND> mapBoth(Function<? super F, ? extends NEW_FIRST> firstMapper, Function<? super S, NEW_SECOND> secondMapper) {
        return Pair.of(firstMapper.apply(this.first()), secondMapper.apply(this.second()));
    }

    public <NEW_FIRST> Pair<NEW_FIRST, S> mapFirst(Function<? super F, ? extends NEW_FIRST> mapper) {
        return Pair.of(mapper.apply(this.first()), this.second());
    }

    public <NEW_FIRST> Pair<NEW_FIRST, S> mapFirst(NEW_FIRST newFirst) {
        return Pair.of(newFirst, this.second());
    }

    public <NEW_SECOND> Pair<F, NEW_SECOND> mapSecond(Function<? super S, ? extends NEW_SECOND> mapper) {
        return Pair.of(this.first(), mapper.apply(this.second()));
    }

    public <NEW_SECOND> Pair<F, NEW_SECOND> mapSecond(NEW_SECOND newSecond) {
        return Pair.of(this.first(), newSecond);
    }

    public Map.Entry<F, S> toEntryFS() {
        return new AbstractMap.SimpleImmutableEntry<F, S>(this.first(), this.second());
    }

    public Map.Entry<S, F> toEntrySF() {
        return new AbstractMap.SimpleImmutableEntry<S, F>(this.second(), this.first());
    }

    public Pair<F, S> clearFirst() {
        return Pair.of(null, this.second());
    }

    public Pair<F, S> clearSecond() {
        return Pair.of(this.first(), null);
    }

    public Pair<S, F> swap() {
        return Pair.of(this.second(), this.first());
    }

    public Optional<Pair<F, S>> toOptional() {
        if (this.first() == null || this.second() == null) {
            return Optional.empty();
        }
        if (!Pair.unsafePredicateTest(Pair.getIsPresentPredicate(this.first().getClass()), this.first())) {
            return Optional.empty();
        }
        if (!Pair.unsafePredicateTest(Pair.getIsPresentPredicate(this.second().getClass()), this.second())) {
            return Optional.empty();
        }
        return Optional.of(this);
    }

    private static <T, Z> boolean unsafePredicateTest(Predicate<Z> predicate, T object) {
        return predicate.test(object);
    }

    static {
        Pair.registerIsPresentPredicate(Optional.class, Optional::isPresent);
        Pair.registerIsPresentPredicate(Response.class, Response::isPresent);
    }
}

