/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.schemas.file;

import io.github.matyrobbrt.curseforgeapi.annotation.Nullable;
import io.github.matyrobbrt.curseforgeapi.schemas.SortableGameVersion;
import io.github.matyrobbrt.curseforgeapi.schemas.file.FileDependency;
import io.github.matyrobbrt.curseforgeapi.schemas.file.FileHash;
import io.github.matyrobbrt.curseforgeapi.schemas.file.FileModule;
import io.github.matyrobbrt.curseforgeapi.schemas.file.FileReleaseType;
import io.github.matyrobbrt.curseforgeapi.schemas.file.FileStatus;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.List;

public record File(int id, int gameId, int modId, boolean isAvailable, String displayName, String fileName, FileReleaseType releaseType, FileStatus fileStatus, List<FileHash> hashes, String fileDate, int fileLength, int downloadCount, String downloadUrl, List<String> gameVersions, List<SortableGameVersion> sortableGameVersions, List<FileDependency> dependencies, @Nullable Boolean exposeAsAlternative, @Nullable Integer parentProjectFileId, @Nullable Integer alternateFileId, @Nullable Boolean isServerPack, @Nullable Integer serverPackFileId, int fileFingerprint, List<FileModule> modules) {
    public void download(Path path) throws IOException {
        URL url = new URL(this.downloadUrl());
        if (path.getParent() != null) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        if (path.toFile().exists()) {
            throw new FileAlreadyExistsException(path.toString());
        }
        try (ReadableByteChannel readChannel = Channels.newChannel(url.openStream());
             FileOutputStream fos = new FileOutputStream(path.toFile());){
            FileChannel writeChannel = fos.getChannel();
            writeChannel.transferFrom(readChannel, 0L, Long.MAX_VALUE);
        }
    }

    public Instant getFileDateAsInstant() {
        return Instant.parse(this.fileDate);
    }
}

