/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request.uploadapi;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.matyrobbrt.curseforgeapi.annotation.Nonnull;
import io.github.matyrobbrt.curseforgeapi.request.uploadapi.ChangelogType;
import io.github.matyrobbrt.curseforgeapi.schemas.file.FileRelationType;
import io.github.matyrobbrt.curseforgeapi.schemas.file.FileReleaseType;
import io.github.matyrobbrt.curseforgeapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class UploadQuery {
    private final String changelog;
    private ChangelogType changelogType;
    private String displayName;
    private Integer parentFileID = null;
    private int[] gameVersions;
    private final FileReleaseType releaseType;
    private final List<Pair<String, FileRelationType>> relations = new ArrayList<Pair<String, FileRelationType>>();

    private UploadQuery(@Nonnull String changelog, @Nonnull FileReleaseType releaseType) {
        this.changelog = changelog;
        this.releaseType = releaseType;
    }

    public static UploadQuery make(@Nonnull String changelog, @Nonnull FileReleaseType releaseType) {
        return new UploadQuery(changelog, releaseType);
    }

    public UploadQuery changelogType(ChangelogType changelogType) {
        this.changelogType = changelogType;
        return this;
    }

    public UploadQuery displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public UploadQuery parentFileID(int parentFileID) {
        this.parentFileID = parentFileID;
        return this;
    }

    public UploadQuery gameVersions(int ... gameVersions) {
        this.gameVersions = gameVersions;
        return this;
    }

    public UploadQuery addRelation(@Nonnull String slug, @Nonnull FileRelationType type) {
        this.relations.add(Pair.of(slug, type));
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("changelog", this.changelog);
        if (this.changelogType != null) {
            json.addProperty("changelogType", this.changelogType.toString().toLowerCase(Locale.ENGLISH));
        }
        if (this.displayName != null) {
            json.addProperty("displayName", this.displayName);
        }
        if (this.parentFileID != null) {
            json.addProperty("parentFileID", this.parentFileID);
        }
        JsonArray arr = new JsonArray();
        if (this.gameVersions != null) {
            for (int i : this.gameVersions) {
                arr.add(i);
            }
        }
        json.add("gameVersions", arr);
        json.addProperty("releaseType", this.releaseType.toString().toLowerCase(Locale.ENGLISH));
        arr = new JsonArray();
        this.relations.forEach(pair -> pair.accept((slug, type) -> {
            JsonObject o = new JsonObject();
            o.addProperty("slug", (String)slug);
            o.addProperty("type", type.uploadApiName());
            arr.add(o);
        }));
        JsonObject nO = new JsonObject();
        nO.add("projects", arr);
        json.add("relations", nO);
        return json;
    }
}

