/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request.uploadapi;

import com.github.mizosoft.methanol.MultipartBodyPublisher;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import io.github.matyrobbrt.curseforgeapi.request.Method;
import io.github.matyrobbrt.curseforgeapi.request.uploadapi.GameDependency;
import io.github.matyrobbrt.curseforgeapi.request.uploadapi.GameVersion;
import io.github.matyrobbrt.curseforgeapi.request.uploadapi.UploadApiRequest;
import io.github.matyrobbrt.curseforgeapi.request.uploadapi.UploadQuery;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;

public final class UploadApiRequests {
    public static UploadApiRequest<List<GameDependency>> getGameDependencies() {
        return new UploadApiRequest<List<GameDependency>>("/api/game/dependencies", Method.GET, null, (gson, json) -> (List)gson.fromJson((JsonElement)json, new TypeToken<List<GameDependency>>(){}.getType()));
    }

    public static UploadApiRequest<List<GameVersion>> getGameVersions() {
        return new UploadApiRequest<List<GameVersion>>("/api/game/versions", Method.GET, null, (gson, json) -> (List)gson.fromJson((JsonElement)json, new TypeToken<List<GameVersion>>(){}.getType()));
    }

    public static UploadApiRequest<Integer> uploadFile(int projectId, UploadQuery uploadQuery, Path filePath) throws FileNotFoundException {
        MultipartBodyPublisher multipartBody = MultipartBodyPublisher.newBuilder().textPart("metadata", uploadQuery.toJson().toString()).filePart("file", filePath).build();
        return new UploadApiRequest<Integer>("/api/projects/%s/upload-file".formatted(projectId), Method.POST, multipartBody, new BiFunction<Gson, JsonElement, Integer>(){

            @Override
            public Integer apply(Gson t2, JsonElement u) {
                return u.getAsJsonObject().get("id").getAsInt();
            }
        }, "multipart/form-data");
    }
}

