/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request.query;

import io.github.matyrobbrt.curseforgeapi.request.Arguments;
import io.github.matyrobbrt.curseforgeapi.request.query.Query;
import io.github.matyrobbrt.curseforgeapi.schemas.Category;
import io.github.matyrobbrt.curseforgeapi.schemas.game.Game;
import io.github.matyrobbrt.curseforgeapi.schemas.mod.ModLoaderType;
import io.github.matyrobbrt.curseforgeapi.util.Utils;

public final class ModSearchQuery
implements Query {
    private int gameId;
    private Integer classId;
    private Integer categoryId;
    private String gameVersion;
    private String searchFilter;
    private SortField sortField;
    private SortOrder sortOrder;
    private ModLoaderType modLoaderType;
    private Integer gameVersionTypeId;
    private String slug;
    private Integer index;
    private Integer pageSize;

    public static ModSearchQuery of(Game game) {
        return ModSearchQuery.of(game.id());
    }

    public static ModSearchQuery of(int gameId) {
        return new ModSearchQuery(gameId);
    }

    private ModSearchQuery(int gameId) {
        this.gameId = gameId;
    }

    public ModSearchQuery classId(int classId) {
        this.classId = classId;
        return this;
    }

    public ModSearchQuery categoryId(int categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    public ModSearchQuery category(Category category) {
        return this.categoryId(category.id());
    }

    public ModSearchQuery gameVersion(String gameVersion) {
        this.gameVersion = gameVersion;
        return this;
    }

    public ModSearchQuery searchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
        return this;
    }

    public ModSearchQuery sortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public ModSearchQuery sortField(SortField sortField) {
        this.sortField = sortField;
        return this;
    }

    public ModSearchQuery modLoaderType(ModLoaderType modLoaderType) {
        this.modLoaderType = modLoaderType;
        return this;
    }

    public ModSearchQuery gameVersionTypeId(int gameVersionTypeId) {
        this.gameVersionTypeId = gameVersionTypeId;
        return this;
    }

    public ModSearchQuery slug(String slug) {
        this.slug = slug;
        return this;
    }

    public ModSearchQuery index(int index) {
        this.index = index;
        return this;
    }

    public ModSearchQuery pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public Arguments toArgs() {
        return Arguments.of("gameId", this.gameId).put("classId", this.classId).put("categoryId", this.categoryId).put("gameVersion", Utils.encodeURL(this.gameVersion)).put("searchFilter", Utils.encodeURL(this.searchFilter)).put("sortField", this.sortField == null ? null : Integer.valueOf(this.sortField.ordinal() + 1)).put("sortOrder", this.sortOrder == null ? null : this.sortOrder.toString()).put("modLoaderType", this.modLoaderType == null ? null : Integer.valueOf(this.modLoaderType.ordinal())).put("gameVersionTypeId", this.gameVersionTypeId).put("slug", Utils.encodeURL(this.slug)).put("index", this.index).put("pageSize", this.pageSize);
    }

    public String toString() {
        return this.toArgs().build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SortOrder {
        ASCENDENT{

            public String toString() {
                return "asc";
            }
        }
        ,
        DESCENDENT{

            public String toString() {
                return "desc";
            }
        };

    }

    public static enum SortField {
        FEATURED,
        POPULARITY,
        LAST_UPDATED,
        NAME,
        AUTHOR,
        TOTAL_DOWNLOADS,
        CATEGORY,
        GAME_VERSION;

    }
}

