/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request.query;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.matyrobbrt.curseforgeapi.schemas.game.Game;
import io.github.matyrobbrt.curseforgeapi.util.Pair;
import java.util.ArrayList;
import java.util.List;

public class GetFuzzyMatchesQuery {
    private final int gameId;
    private final List<Pair<String, int[]>> fingerprints = new ArrayList<Pair<String, int[]>>();

    public static GetFuzzyMatchesQuery forGame(Game game) {
        return GetFuzzyMatchesQuery.forGame(game.id());
    }

    public static GetFuzzyMatchesQuery forGame(int gameId) {
        return new GetFuzzyMatchesQuery(gameId);
    }

    private GetFuzzyMatchesQuery(int gameId) {
        this.gameId = gameId;
    }

    public GetFuzzyMatchesQuery addFingerprint(String foldername, int ... fingerprints) {
        this.fingerprints.add(Pair.of(foldername, fingerprints));
        return this;
    }

    public JsonObject toJson() {
        JsonObject jObj = new JsonObject();
        jObj.addProperty("gameId", this.gameId);
        JsonArray fgArray = new JsonArray();
        this.fingerprints.forEach(pair -> {
            JsonObject obj = new JsonObject();
            obj.addProperty("foldername", (String)pair.first());
            JsonArray ar = new JsonArray();
            for (int i : (int[])pair.second()) {
                ar.add(i);
            }
            obj.add("fingerprints", ar);
            fgArray.add(obj);
        });
        return jObj;
    }
}

